/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Predicate;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableUpdateType;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import ru.cedrusdata.catalog.CurrentTimeSupplier;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.AuthorizerObjectType;
import ru.cedrusdata.catalog.core.security.authorization.securable.NamespaceInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIO;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.table.CatalogTableOperations;
import ru.cedrusdata.catalog.iceberg.table.IcebergCteDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergInternalTableService;
import ru.cedrusdata.catalog.iceberg.table.IcebergMaterializedViewDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergMaterializedViewSnapshotDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectExtendedDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataUtils;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableUtils;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectCommitFailedException;

public class IcebergTableOperations
extends BaseMetastoreTableOperations
implements CatalogTableOperations {
    private final Authorizer authorizer;
    private final IcebergInternalTableService tableService;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final CurrentTimeSupplier currentTimeSupplier;
    private final boolean hasMaintenancePrincipal;
    private final IcebergNamespaceContext namespaceContext;
    private final Optional<IcebergObjectExtendedDetails> targetObjectDetails;
    private final String tableName;
    private final CatalogIcebergFileIO io;
    private TableMetadata committedMetadata;
    private String committedMetadataLocation;

    public IcebergTableOperations(Authorizer authorizer, IcebergInternalTableService tableService, IcebergTableMetadataCache tableMetadataCache, CurrentTimeSupplier currentTimeSupplier, boolean hasMaintenancePrincipal, IcebergNamespaceContext namespaceContext, Optional<IcebergObjectExtendedDetails> targetObjectDetails, String tableName, CatalogIcebergFileIO io) {
        this.authorizer = authorizer;
        this.tableService = tableService;
        this.tableMetadataCache = tableMetadataCache;
        this.currentTimeSupplier = currentTimeSupplier;
        this.hasMaintenancePrincipal = hasMaintenancePrincipal;
        this.namespaceContext = namespaceContext;
        this.targetObjectDetails = targetObjectDetails;
        this.tableName = tableName;
        this.io = io;
    }

    protected void doRefresh() {
        Optional<String> newMetadataLocation;
        Optional<String> optional = newMetadataLocation = this.committedMetadataLocation != null ? Optional.of(this.committedMetadataLocation) : this.targetObjectDetails.map(IcebergObjectExtendedDetails::metadataLocation);
        if (newMetadataLocation.isEmpty()) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchTableException("Table does not exist: %s", new Object[]{TableIdentifier.of((String[])new String[]{this.namespaceContext.namespaceName(), this.tableName})});
            }
            this.disableRefresh();
        } else {
            this.refreshFromMetadataLocation(newMetadataLocation.get(), IcebergTableMetadataUtils::shouldRetryMetadataRead, 20, this::readMetadata);
        }
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        throw new UnsupportedOperationException("Should not be called");
    }

    protected void refreshFromMetadataLocation(String newLocation, int numRetries) {
        throw new UnsupportedOperationException("Should not be called");
    }

    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries) {
        throw new UnsupportedOperationException("Should not be called");
    }

    private TableMetadata readMetadata(String metadataLocation) {
        return IcebergTableMetadataUtils.readMetadata(this.tableMetadataCache, this.namespaceContext, this.tableName, IcebergTableType.TABLE, (FileIO)this.io(), metadataLocation, TableMetadataParser::fromJson);
    }

    @Override
    public TableMetadata lastCommittedMetadata() {
        return this.committedMetadata;
    }

    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        try {
            String newLocation = this.writeNewMetadataIfRequired(base == null, metadata);
            Optional<String> oldLocation = Optional.ofNullable(base == null ? null : base.metadataFileLocation());
            Optional<IcebergMaterializedViewDetails> materializedViewDetails = IcebergTableOperations.extractMaterializedViewDetails(metadata);
            Optional<IcebergCteDetails> cteDetails = this.extractCteDetails(metadata);
            this.authorize(metadata, materializedViewDetails.isPresent(), base == null);
            this.tableService.createOrUpdate(this.namespaceContext, this.targetObjectDetails.map(IcebergObjectExtendedDetails::objectId), this.tableName, materializedViewDetails.isPresent() ? AuthorizerObjectType.MATERIALIZED_VIEW : AuthorizerObjectType.TABLE, newLocation, oldLocation, materializedViewDetails, cteDetails);
            this.committedMetadata = metadata;
            this.committedMetadataLocation = newLocation;
        }
        catch (IcebergObjectAlreadyExistsException e) {
            throw new AlreadyExistsException(e.getMessage(), new Object[0]);
        }
        catch (IcebergObjectCommitFailedException e) {
            throw new CommitFailedException(e.getMessage(), new Object[0]);
        }
    }

    private void authorize(TableMetadata metadata, boolean mv, boolean create) {
        AuthenticatedPrincipal principal = this.namespaceContext.catalogContext().currentPrincipal();
        NamespaceInternalSecurable namespaceSecurable = this.namespaceContext.toSecurable();
        if (create) {
            this.authorizer.authorizeObjectCreate(principal, namespaceSecurable, mv ? AuthorizerObjectType.MATERIALIZED_VIEW : AuthorizerObjectType.TABLE);
        } else {
            Verify.verify((boolean)this.targetObjectDetails.isPresent());
            ObjectInternalSecurable objectSecurable = this.targetObjectDetails.get().toSecurable(namespaceSecurable);
            SortedSet<TableUpdateType> updateTypes = TableUpdateType.determineUpdateType(metadata);
            for (TableUpdateType updateType : updateTypes) {
                updateType.authorize(this.authorizer, principal, objectSecurable);
            }
        }
    }

    private static Optional<IcebergMaterializedViewDetails> extractMaterializedViewDetails(TableMetadata metadata) {
        String plan;
        if (!IcebergTableUtils.isMaterializedView(metadata.properties())) {
            return Optional.empty();
        }
        Optional<IcebergMaterializedViewSnapshotDetails> materializedViewSnapshotDetails = Optional.empty();
        Snapshot snapshot = metadata.currentSnapshot();
        if (snapshot != null && (plan = (String)snapshot.summary().get("cedrusdata-mv-rewrite-plan")) != null) {
            HashSet<String> referencedTables = new HashSet<String>();
            String referencedTablesStr = (String)snapshot.summary().get("cedrusdata-mv-rewrite-referenced-tables");
            if (referencedTablesStr != null) {
                referencedTables.addAll(Arrays.asList(referencedTablesStr.split(",")));
            }
            materializedViewSnapshotDetails = Optional.of(new IcebergMaterializedViewSnapshotDetails(snapshot.snapshotId(), plan, referencedTables));
        }
        return Optional.of(new IcebergMaterializedViewDetails(materializedViewSnapshotDetails));
    }

    private Optional<IcebergCteDetails> extractCteDetails(TableMetadata metadata) {
        Map tableProperties = metadata.properties();
        Optional<Long> ttl = IcebergTableUtils.cteTableTtl(tableProperties);
        if (ttl.isEmpty()) {
            return Optional.empty();
        }
        long expiresAt = this.currentTimeSupplier.currentTimeMillis() + ttl.get();
        if ("true".equalsIgnoreCase((String)tableProperties.get("cedrusdata-cte-reusable")) && !this.hasMaintenancePrincipal) {
            throw new CatalogBadRequestException(String.format("Cannot save reusable CTE table because the maintenance principal is not set (please set the \"%s\" catalog property)", "cedrusdata-maintenance-principal"));
        }
        Optional<String> canonicalPlan = Optional.empty();
        Snapshot snapshot = metadata.currentSnapshot();
        if (snapshot != null) {
            canonicalPlan = Optional.ofNullable((String)snapshot.summary().get("cedrusdata-cte-canonical-plan"));
        }
        return Optional.of(new IcebergCteDetails(expiresAt, canonicalPlan));
    }

    protected String tableName() {
        return this.namespaceContext.catalogContext().catalogName() + "." + this.namespaceContext.namespaceName() + "." + this.tableName;
    }

    public CatalogIcebergFileIO io() {
        return this.io;
    }
}

