/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import jakarta.annotation.PreDestroy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import ru.cedrusdata.catalog.CurrentTimeSupplier;
import ru.cedrusdata.catalog.config.CatalogIcebergConfig;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableService;
import ru.cedrusdata.catalog.store.IcebergCatalogStore;

public class IcebergMaintenanceService {
    private static final Logger log = Logger.get(IcebergMaintenanceService.class);
    private final IcebergCatalogStore catalogStore;
    private final PrincipalService principalService;
    private final IcebergTableService tableService;
    private final CurrentTimeSupplier currentTimeSupplier;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"iceberg-cte-cleanup"));
    private final Map<UUID, String> catalogsWithBadMaintenancePrincipals = new HashMap<UUID, String>();

    @Inject
    public IcebergMaintenanceService(IcebergCatalogStore catalogStore, PrincipalService principalService, IcebergTableService tableService, CurrentTimeSupplier currentTimeSupplier, CatalogIcebergConfig config) {
        this.catalogStore = catalogStore;
        this.principalService = principalService;
        this.tableService = tableService;
        this.currentTimeSupplier = currentTimeSupplier;
        long cleanupInterval = config.getMaintenanceCteMaterializationCleanupInterval().toMillis();
        this.executor.scheduleWithFixedDelay(this::cleanup, cleanupInterval, cleanupInterval, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdownNow();
    }

    private void cleanup() {
        List<IcebergCatalogDetails> catalogs = this.catalogStore.listDetails();
        this.cleanupOrphanedBadCleanupPrincipals(catalogs);
        long currentTime = this.currentTimeSupplier.currentTimeMillis();
        for (IcebergCatalogDetails catalog : catalogs) {
            this.cleanup(catalog, currentTime);
        }
    }

    private void cleanup(IcebergCatalogDetails catalog, long currentTime) {
        String maintenancePrincipalName = catalog.properties().get("cedrusdata-maintenance-principal");
        if (maintenancePrincipalName == null) {
            return;
        }
        Optional<AuthenticatedPrincipal> principal = this.principalService.authenticate(maintenancePrincipalName);
        if (principal.isEmpty()) {
            String oldMaintenancePrincipalName = this.catalogsWithBadMaintenancePrincipals.put(catalog.catalogId(), maintenancePrincipalName);
            if (!maintenancePrincipalName.equals(oldMaintenancePrincipalName)) {
                log.warn("Cannot perform catalog \"%s\" maintenance because authentication failed for the maintenance principal \"%s\" (please update the \"%s\" catalog property)", new Object[]{catalog.catalogName(), maintenancePrincipalName, "cedrusdata-maintenance-principal"});
            }
            return;
        }
        this.catalogsWithBadMaintenancePrincipals.remove(catalog.catalogId());
        this.tableService.dropExpiredCteTables(principal.get(), catalog, currentTime);
    }

    private void cleanupOrphanedBadCleanupPrincipals(List<IcebergCatalogDetails> catalogs) {
        Set existingCatalogIds = catalogs.stream().map(IcebergCatalogDetails::catalogId).collect(Collectors.toSet());
        HashSet<UUID> badCatalogIds = new HashSet<UUID>(this.catalogsWithBadMaintenancePrincipals.keySet());
        for (UUID catalogId : badCatalogIds) {
            if (existingCatalogIds.contains(catalogId)) continue;
            this.catalogsWithBadMaintenancePrincipals.remove(catalogId);
        }
    }
}

