/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.google.common.base.Verify;
import io.airlift.log.Logger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.view.BaseMetastoreViewCatalog;
import org.apache.iceberg.view.ViewMetadata;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.CurrentTimeSupplier;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIO;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIOFactory;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.rest.IcebergOptions;
import ru.cedrusdata.catalog.iceberg.table.IcebergInternalTableService;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectExtendedDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableOperations;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.iceberg.table.IcebergViewOperations;

public class IcebergCatalog
extends BaseMetastoreViewCatalog {
    private static final Logger logger = Logger.get(IcebergCatalog.class);
    private final IcebergInternalTableService tableService;
    private final Authorizer authorizer;
    private final CurrentTimeSupplier currentTimeSupplier;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final IcebergNamespaceContext namespaceContext;
    private final Optional<IcebergObjectExtendedDetails> targetObjectDetails;
    private final CatalogIcebergFileIOFactory ioFactory;
    private final IcebergOptions icebergOptions;

    public IcebergCatalog(IcebergInternalTableService tableService, Authorizer authorizer, CurrentTimeSupplier currentTimeSupplier, IcebergTableMetadataCache tableMetadataCache, IcebergNamespaceContext namespaceContext, Optional<IcebergObjectExtendedDetails> targetObjectDetails, CatalogIcebergFileIOFactory ioFactory, IcebergOptions icebergOptions) {
        this.tableService = tableService;
        this.authorizer = authorizer;
        this.currentTimeSupplier = currentTimeSupplier;
        this.tableMetadataCache = tableMetadataCache;
        this.namespaceContext = namespaceContext;
        this.targetObjectDetails = targetObjectDetails;
        this.ioFactory = ioFactory;
        this.icebergOptions = icebergOptions;
    }

    protected IcebergTableOperations newTableOps(TableIdentifier tableIdentifier) {
        return new IcebergTableOperations(this.authorizer, this.tableService, this.tableMetadataCache, this.currentTimeSupplier, this.namespaceContext.catalogContext().hasMaintenancePrincipal(), this.namespaceContext, this.targetObjectDetails, CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(tableIdentifier.name()), this.createFileIO());
    }

    protected IcebergViewOperations newViewOps(TableIdentifier viewIdentifier) {
        return new IcebergViewOperations(this.authorizer, this.tableService, this.tableMetadataCache, this.namespaceContext, this.targetObjectDetails, CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(viewIdentifier.name()), this.createFileIO());
    }

    private CatalogIcebergFileIO createFileIO() {
        AuthenticatedPrincipal principal = this.namespaceContext.catalogContext().currentPrincipal();
        return this.ioFactory.createFileIO(principal, this.icebergOptions);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        String normalizedNamespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(tableIdentifier.namespace().level(0));
        String normalizedTableName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(tableIdentifier.name());
        return this.namespaceContext.catalogContext().defaultLocationProvider().defaultRestObjectLocation(normalizedNamespaceName, normalizedTableName).orElse(null);
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        throw new UnsupportedOperationException("listTables should not be called");
    }

    public List<TableIdentifier> listViews(Namespace namespace) {
        throw new UnsupportedOperationException("listViews should not be called");
    }

    public boolean dropTable(TableIdentifier tableIdentifier, boolean purge) {
        boolean deleted;
        Verify.verify((boolean)this.targetObjectDetails.isPresent());
        IcebergTableOperations ops = this.newTableOps(tableIdentifier);
        TableMetadata lastMetadata = null;
        if (purge) {
            try {
                lastMetadata = ops.current();
            }
            catch (NotFoundException e) {
                logger.warn((Throwable)e, String.format("Failed to load table \"%s\" metadata, continuing drop without purge", tableIdentifier));
            }
        }
        if (!(deleted = this.tableService.delete(this.namespaceContext, this.targetObjectDetails.get().objectId(), tableIdentifier.name(), IcebergTableType.TABLE))) {
            return false;
        }
        if (purge && lastMetadata != null) {
            try {
                CatalogUtil.dropTableData((FileIO)ops.io(), (TableMetadata)lastMetadata);
                IcebergCatalog.dropObjectLocation(ops.io(), lastMetadata.properties(), lastMetadata.location());
            }
            catch (Exception e) {
                logger.warn((Throwable)e, String.format("Failed to delete table \"%s\" data: " + e.getMessage(), tableIdentifier));
            }
        }
        return true;
    }

    public boolean dropView(TableIdentifier viewIdentifier) {
        Verify.verify((boolean)this.targetObjectDetails.isPresent());
        IcebergViewOperations ops = this.newViewOps(viewIdentifier);
        ViewMetadata lastMetadata = null;
        try {
            lastMetadata = ops.current();
        }
        catch (NotFoundException e) {
            logger.warn((Throwable)e, String.format("Failed to load view \"%s\" metadata, continuing drop without purge", viewIdentifier));
        }
        boolean deleted = this.tableService.delete(this.namespaceContext, this.targetObjectDetails.get().objectId(), viewIdentifier.name(), IcebergTableType.VIEW);
        if (!deleted) {
            return false;
        }
        if (lastMetadata != null) {
            try {
                IcebergCatalog.dropViewMetadata((FileIO)ops.io(), lastMetadata);
                IcebergCatalog.dropObjectLocation(ops.io(), lastMetadata.properties(), lastMetadata.location());
            }
            catch (Exception e) {
                logger.warn((Throwable)e, "Failed to delete view \"%s\" metadata: %s", new Object[]{viewIdentifier, e.getMessage()});
            }
        }
        return true;
    }

    private static void dropViewMetadata(FileIO io, ViewMetadata metadata) {
        boolean gcEnabled = PropertyUtil.propertyAsBoolean((Map)metadata.properties(), (String)"gc.enabled", (boolean)true);
        if (gcEnabled) {
            IcebergCatalog.deleteFile(io, metadata.metadataFileLocation(), "metadata");
        }
    }

    private static void deleteFile(FileIO io, String file, String type) {
        try {
            io.deleteFile(file);
        }
        catch (RuntimeException e) {
            logger.warn((Throwable)e, "Failed to delete %s file %s", new Object[]{type, file});
        }
    }

    private static void dropObjectLocation(CatalogIcebergFileIO io, Map<String, String> objectProperties, String objectLocation) {
        boolean gcEnabled = PropertyUtil.propertyAsBoolean(objectProperties, (String)"gc.enabled", (boolean)true);
        if (gcEnabled) {
            try {
                io.deleteDirectory(objectLocation);
            }
            catch (RuntimeException e) {
                logger.warn((Throwable)e, "Failed to delete object directory %s", new Object[]{objectLocation});
            }
        }
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        throw new UnsupportedOperationException("renameTable should not be called");
    }

    public void renameView(TableIdentifier from, TableIdentifier to) {
        throw new UnsupportedOperationException("renameView should not be called");
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

