/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.rest.responses.ConfigResponse;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientFactory;
import ru.cedrusdata.catalog.iceberg.rest.AbstractIcebergResource;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;

@ResourceType(value=ResourceType.Type.ICEBERG)
@ResourceSecurity(value=ResourceSecurity.Type.AUTHENTICATED)
@Path(value="/catalog/iceberg/v1")
public class IcebergConfigResource
extends AbstractIcebergResource {
    @Inject
    public IcebergConfigResource(EmbeddedInternalCatalogClientFactory clientFactory) {
        super(clientFactory);
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig(@QueryParam(value="warehouse") String catalogName, @Context SecurityContext securityContext) {
        catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalogName);
        ConfigResponse response = this.createClient(securityContext).restIcebergGetConfig(catalogName);
        return Response.ok().entity((Object)response).build();
    }
}

