/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.io;

import java.util.HashMap;
import java.util.Map;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIO;
import ru.cedrusdata.catalog.iceberg.rest.IcebergOptions;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemFactory;

public class CatalogIcebergFileIOFactory
implements AutoCloseable {
    private final CatalogFileSystemFactory factory;
    private final Map<Key, CatalogIcebergFileIO> fileIOs = new HashMap<Key, CatalogIcebergFileIO>();

    public CatalogIcebergFileIOFactory(CatalogFileSystemFactory factory) {
        this.factory = factory;
    }

    public CatalogIcebergFileIO createFileIO(AuthenticatedPrincipal principal, IcebergOptions icebergOptions) {
        Key key = new Key(principal.name(), icebergOptions);
        return this.fileIOs.computeIfAbsent(key, k -> new CatalogIcebergFileIO(this.factory.create(k.principalName(), k.options().toMap())));
    }

    @Override
    public void close() {
        for (CatalogIcebergFileIO fileIO : this.fileIOs.values()) {
            try {
                fileIO.close();
            }
            catch (Exception exception) {}
        }
    }

    private record Key(String principalName, IcebergOptions options) {
    }
}

