/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;

public class IcebergLocation {
    private static final Splitter SCHEME_SPLITTER = Splitter.on((String)":").limit(2);
    private static final Splitter USER_INFO_SPLITTER = Splitter.on((char)'@').limit(2);
    private static final Splitter AUTHORITY_SPLITTER = Splitter.on((char)'/').limit(2);
    private static final Splitter HOST_AND_PORT_SPLITTER = Splitter.on((char)':').limit(2);
    private final String location;
    private final Optional<String> scheme;
    private final Optional<String> userInfo;
    private final Optional<String> host;
    private final OptionalInt port;
    private final String path;

    public static IcebergLocation of(String location) {
        Objects.requireNonNull(location, "location is null");
        Preconditions.checkArgument((!location.isEmpty() ? 1 : 0) != 0, (Object)"location is empty");
        Preconditions.checkArgument((!location.isBlank() ? 1 : 0) != 0, (Object)"location is blank");
        if (location.startsWith("/")) {
            return new IcebergLocation(location, Optional.empty(), Optional.empty(), Optional.empty(), OptionalInt.empty(), location.substring(1));
        }
        List schemeSplit = SCHEME_SPLITTER.splitToList((CharSequence)location);
        Preconditions.checkArgument((schemeSplit.size() == 2 ? 1 : 0) != 0, (String)"No scheme for file system location: %s", (Object)location);
        String scheme = (String)schemeSplit.get(0);
        String afterScheme = (String)schemeSplit.get(1);
        if (afterScheme.startsWith("//")) {
            List authoritySplit = AUTHORITY_SPLITTER.splitToList((CharSequence)(afterScheme = afterScheme.substring(2)));
            List userInfoSplit = USER_INFO_SPLITTER.splitToList((CharSequence)authoritySplit.get(0));
            Optional<String> userInfo = userInfoSplit.size() == 2 ? Optional.of((String)userInfoSplit.get(0)) : Optional.empty();
            List hostAndPortSplit = HOST_AND_PORT_SPLITTER.splitToList((CharSequence)Iterables.getLast((Iterable)userInfoSplit));
            Optional<String> host = Optional.of((String)hostAndPortSplit.get(0)).filter(Predicate.not(String::isEmpty));
            OptionalInt port = OptionalInt.empty();
            if (hostAndPortSplit.size() == 2) {
                try {
                    port = OptionalInt.of(Integer.parseInt((String)hostAndPortSplit.get(1)));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid port in file system location: " + location, e);
                }
            }
            Preconditions.checkArgument((userInfo.isEmpty() && host.isEmpty() && port.isEmpty() || authoritySplit.size() == 2 ? 1 : 0) != 0, (String)"Path missing in file system location: %s", (Object)location);
            String path = authoritySplit.size() == 2 ? (String)authoritySplit.get(1) : "";
            return new IcebergLocation(location, Optional.of(scheme), userInfo, host, port, path);
        }
        Preconditions.checkArgument((boolean)afterScheme.startsWith("/"), (Object)"Path must begin with a '/' when no authority is present");
        return new IcebergLocation(location, Optional.of(scheme), Optional.empty(), Optional.empty(), OptionalInt.empty(), afterScheme.substring(1));
    }

    private IcebergLocation(String location, Optional<String> scheme, Optional<String> userInfo, Optional<String> host, OptionalInt port, String path) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.scheme = Objects.requireNonNull(scheme, "scheme is null");
        this.userInfo = Objects.requireNonNull(userInfo, "userInfo is null");
        this.host = Objects.requireNonNull(host, "host is null");
        this.port = Objects.requireNonNull(port, "port is null");
        this.path = Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument((scheme.isEmpty() || !scheme.get().isEmpty() ? 1 : 0) != 0, (Object)"scheme value is empty");
        Preconditions.checkArgument((host.isEmpty() || !host.get().isEmpty() ? 1 : 0) != 0, (Object)"host value is empty");
    }

    private IcebergLocation withPath(String location, String path) {
        return new IcebergLocation(location, this.scheme, this.userInfo, this.host, this.port, path);
    }

    public IcebergLocation appendPath(String newPathElement) {
        Preconditions.checkArgument((!((String)newPathElement).isEmpty() ? 1 : 0) != 0, (Object)"newPathElement is empty");
        Preconditions.checkArgument((!((String)newPathElement).startsWith("/") ? 1 : 0) != 0, (String)"newPathElement starts with a slash: %s", (Object)newPathElement);
        if (this.path.isEmpty()) {
            return this.appendToEmptyPath((String)newPathElement);
        }
        if (!this.path.endsWith("/")) {
            newPathElement = "/" + (String)newPathElement;
        }
        return this.withPath(this.location + (String)newPathElement, this.path + (String)newPathElement);
    }

    public IcebergLocation appendSuffix(String suffix) {
        if (this.path.isEmpty()) {
            return this.appendToEmptyPath(suffix);
        }
        return this.withPath(this.location + suffix, this.path + suffix);
    }

    private IcebergLocation appendToEmptyPath(String value) {
        boolean needSlash;
        Preconditions.checkState((boolean)this.path.isEmpty());
        boolean bl = needSlash = !this.location.endsWith("/");
        if (this.scheme.isPresent() && this.host.isEmpty() && this.userInfo.isEmpty() && !this.location.endsWith(":///")) {
            needSlash = true;
        }
        return this.withPath(this.location + (needSlash ? "/" : "") + value, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof IcebergLocation)) return false;
        IcebergLocation that = (IcebergLocation)o;
        if (!this.location.equals(that.location)) return false;
        return true;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public String toString() {
        return this.location;
    }
}

