/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.catalog;

import java.util.Optional;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergLocation;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public class IcebergCatalogDefaultLocationProvider {
    private final String catalogName;
    private final Optional<String> fileSystemLocation;

    public IcebergCatalogDefaultLocationProvider(String catalogName, Optional<String> fileSystemLocation) {
        this.catalogName = catalogName;
        this.fileSystemLocation = fileSystemLocation;
    }

    public Optional<String> defaultLocation() {
        return this.fileSystemLocation.map(IcebergCatalogDefaultLocationProvider::normalizeAsDirectory);
    }

    public String defaultRestNamespaceLocation(String namespaceName) {
        if (this.fileSystemLocation.isEmpty()) {
            throw new CatalogBadRequestException("Catalog \"%s\" doesn't have a default location (please provide location explicitly)".formatted(this.catalogName));
        }
        return IcebergCatalogDefaultLocationProvider.appendSuffix(this.fileSystemLocation.get(), namespaceName);
    }

    public Optional<String> defaultRestObjectLocation(String namespaceName, String tableName) {
        if (this.fileSystemLocation.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(IcebergCatalogDefaultLocationProvider.appendSuffix(IcebergCatalogDefaultLocationProvider.appendSuffix(this.fileSystemLocation.get(), namespaceName), tableName));
    }

    private static String appendSuffix(String base, String suffix) {
        return IcebergLocation.of(IcebergCatalogDefaultLocationProvider.normalizeAsDirectory(base)).appendSuffix(suffix).toString();
    }

    private static String normalizeAsDirectory(String location) {
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return location;
    }
}

