/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.provider;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurityProviderInternalSecurable;
import ru.cedrusdata.catalog.plugin.PluginPropertyClassifier;
import ru.cedrusdata.catalog.spi.model.SecurityProviderInfo;

public record SecurityProviderDetails(UUID id, String name, String description, String type, Map<String, String> properties, Optional<UUID> ownerId, String ownerName) {
    public SecurityProviderInfo toInfo(PluginPropertyClassifier propertyClassifier) {
        ImmutableMap.Builder finalProperties = ImmutableMap.builder();
        ImmutableSet.Builder finalRedactedProperties = ImmutableSet.builder();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            if (propertyClassifier.shouldRedact(this.type, key)) {
                finalRedactedProperties.add((Object)key);
                continue;
            }
            finalProperties.put((Object)key, (Object)entry.getValue());
        }
        return new SecurityProviderInfo(this.name, this.type, this.ownerName, this.description, (Map)finalProperties.buildOrThrow(), (Set)finalRedactedProperties.build());
    }

    public SecurityProviderInternalSecurable toSecurable() {
        return new SecurityProviderInternalSecurable(new SecurableItem(this.id, this.ownerId, this.name));
    }
}

