/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.securable;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableCollector;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;

public interface InternalSecurable {
    public SecurableType type();

    public SecurableItem resolve(SecurableType var1);

    public void collect(SecurableCollector var1);

    default public UUID id() {
        return this.resolve(this.type()).id();
    }

    default public Optional<UUID> idIfTypeMatches(SecurableType expectedType) {
        return this.type() == expectedType ? Optional.of(this.id()) : Optional.empty();
    }

    default public Optional<UUID> idIfTypeMatches(Set<SecurableType> expectedTypes) {
        for (SecurableType expectedType : expectedTypes) {
            Optional<UUID> result = this.idIfTypeMatches(expectedType);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

