/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.check;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;

public class AuthorizationPrivileges {
    private final Set<PrivilegeEntry> privileges;

    private AuthorizationPrivileges(Set<PrivilegeEntry> privileges) {
        this.privileges = privileges;
    }

    public boolean hasPrivilege(UUID principalId, UUID securableId, CatalogPrivilege privilege) {
        PrivilegeEntry entry = AuthorizationPrivileges.createEntry(principalId, securableId, privilege);
        return this.privileges.contains(entry);
    }

    @VisibleForTesting
    public boolean hasAnyPrincipalPrivilege(UUID principalId) {
        return this.privileges.stream().anyMatch(privilege -> principalId.equals(privilege.principalId()));
    }

    @VisibleForTesting
    public boolean hasAnySecurablePrivilege(UUID securableId) {
        return this.privileges.stream().anyMatch(privilege -> securableId.equals(privilege.securableId()));
    }

    private static PrivilegeEntry createEntry(UUID principalId, UUID securableId, CatalogPrivilege privilege) {
        return new PrivilegeEntry(principalId.getMostSignificantBits(), principalId.getLeastSignificantBits(), securableId.getMostSignificantBits(), securableId.getLeastSignificantBits(), privilege.ordinal());
    }

    private record PrivilegeEntry(long principalHigh, long principalLow, long securableHigh, long securableLow, int privilegeOrdinal) {
        private UUID principalId() {
            return new UUID(this.principalHigh, this.principalLow);
        }

        private UUID securableId() {
            return new UUID(this.securableHigh, this.securableLow);
        }

        @Override
        public String toString() {
            return "principal=" + String.valueOf(new UUID(this.principalHigh, this.principalLow)) + ":securable=" + String.valueOf(new UUID(this.securableHigh, this.securableLow)) + ":privilege=" + String.valueOf((Object)CatalogPrivilege.resolveByOrdinal(this.privilegeOrdinal));
        }
    }

    public static class Builder {
        private final ImmutableSet.Builder<PrivilegeEntry> privileges = ImmutableSet.builder();

        public Builder add(UUID principalId, UUID securableId, CatalogPrivilege privilege) {
            PrivilegeEntry entry = AuthorizationPrivileges.createEntry(principalId, securableId, privilege);
            this.privileges.add((Object)entry);
            return this;
        }

        public AuthorizationPrivileges build() {
            return new AuthorizationPrivileges((Set<PrivilegeEntry>)this.privileges.build());
        }
    }
}

