/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.check;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckContext;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResultStep;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCompositeCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationOwnerOrPrivilegeCheck;
import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableTypeUsagePrivileges;

public class AuthorizationPrivilegeDynamicCheck
implements AuthorizationCheck {
    private static final Map<SecurableType, List<AuthorizationOwnerOrPrivilegeCheck>> OWNER_CHECKS;
    private final AuthorizationOwnerOrPrivilegeCheck targetCheck;

    private static List<AuthorizationOwnerOrPrivilegeCheck> ownerChecksForSecurableType(SecurableType securableType) {
        Optional<SecurableType> parentSecurableType = securableType.parent();
        ArrayList<AuthorizationOwnerOrPrivilegeCheck> checks = new ArrayList<AuthorizationOwnerOrPrivilegeCheck>();
        while (parentSecurableType.isPresent()) {
            Optional<CatalogPrivilege> privilege = SecurableTypeUsagePrivileges.usagePrivilege(parentSecurableType.get());
            if (privilege.isPresent()) {
                checks.addLast(new AuthorizationOwnerOrPrivilegeCheck(privilege));
            }
            parentSecurableType = parentSecurableType.get().parent();
        }
        return ImmutableList.copyOf(checks);
    }

    public AuthorizationPrivilegeDynamicCheck(AuthorizationOwnerOrPrivilegeCheck targetCheck) {
        this.targetCheck = targetCheck;
    }

    @Override
    public AuthorizationCheck prepare(InternalSecurable securable) {
        List<AuthorizationOwnerOrPrivilegeCheck> parentChecks = OWNER_CHECKS.get((Object)securable.type());
        if (parentChecks.isEmpty()) {
            return this.targetCheck;
        }
        ArrayList<AuthorizationCheck> checks = new ArrayList<AuthorizationCheck>(parentChecks.size() + 1);
        checks.addAll(parentChecks);
        checks.add(this.targetCheck);
        return AuthorizationCompositeCheck.and(checks);
    }

    @Override
    public AuthorizationCheckResultStep check(AuthorizationCheckContext context) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public String descriptor(InternalSecurable securable) {
        return this.toString();
    }

    public String toString() {
        return "dynamic-usage[" + this.targetCheck.toString() + "]";
    }

    static {
        ImmutableMap.Builder ownerChecksBuilder = ImmutableMap.builder();
        for (SecurableType securableType : SecurableType.values()) {
            ownerChecksBuilder.put((Object)securableType, AuthorizationPrivilegeDynamicCheck.ownerChecksForSecurableType(securableType));
        }
        OWNER_CHECKS = ownerChecksBuilder.buildOrThrow();
    }
}

