/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.principal;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.principal.PrincipalType;
import ru.cedrusdata.catalog.core.security.authorization.securable.PrincipalInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;

public record PrincipalDetails(UUID id, String name, Optional<UUID> ownerId, PrincipalType type, boolean active, Optional<String> hashedPassword, Set<UUID> roleIds, Map<String, String> properties, Optional<UUID> identifiedWith) {
    public AuthenticatedPrincipal toPrincipal(UUID publicRoleId) {
        ImmutableSet finalRoleIds = ImmutableSet.builder().addAll(this.roleIds).add((Object)publicRoleId).build();
        return new AuthenticatedPrincipal(this.id, this.name, this.ownerId, (Set<UUID>)finalRoleIds, this.type == PrincipalType.USER);
    }

    public PrincipalInternalSecurable toSecurable() {
        return new PrincipalInternalSecurable(new SecurableItem(this.id, this.ownerId, this.name));
    }
}

