/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.maintenance;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import ru.cedrusdata.catalog.core.computeengine.ComputeEngineSession;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationExecutor;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationObject;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationResult;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationTarget;
import ru.cedrusdata.catalog.core.maintenance.ObjectGroupIterator;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupService;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableService;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationContext;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationFactory;
import ru.cedrusdata.catalog.spi.computeengine.result.ComputeEngineResultAggregator;

class MaintenanceOperation
implements MaintenanceOperationExecutor.Operation {
    private final int maxErrors;
    private final ComputeEngineSession session;
    private final AuthenticatedPrincipal principal;
    private final CatalogComputeEngineOperationFactory operationFactory;
    private final IcebergTableService tableService;
    private final CompletableFuture<MaintenanceOperationResult> future = new CompletableFuture();
    private final ComputeEngineResultAggregator aggregator;
    private final AtomicLong objectCount = new AtomicLong();
    private final CatalogComputeEngineOperationContext operationContext;
    private final Iterator<MaintenanceOperationObject> objectIterator;
    private Map<String, String> objectErrors;

    public MaintenanceOperation(int maxErrors, ComputeEngineSession session, AuthenticatedPrincipal principal, UUID operationId, CatalogComputeEngineOperationFactory operationFactory, ObjectGroupService objectGroupService, IcebergTableService tableService, MaintenanceOperationTarget target, Map<String, String> engineConfig) {
        this.maxErrors = maxErrors;
        this.session = session;
        this.principal = principal;
        this.operationFactory = operationFactory;
        this.tableService = tableService;
        this.aggregator = operationFactory.createResultAggregator();
        this.operationContext = new CatalogComputeEngineOperationContext(operationId, engineConfig != null ? engineConfig : Map.of());
        if (target.objectGroup().isPresent()) {
            this.objectIterator = ObjectGroupIterator.createForOperation(operationFactory, principal, target.objectGroup().get(), objectGroupService, 100);
        } else {
            Verify.verify((boolean)target.object().isPresent());
            this.objectIterator = Iterators.singletonIterator((Object)target.object().get());
        }
        this.future.thenRun(session::close);
    }

    public CompletableFuture<MaintenanceOperationResult> future() {
        return this.future;
    }

    @Override
    public Iterator<MaintenanceOperationObject> objectIterator() {
        return this.objectIterator;
    }

    @Override
    public void run(MaintenanceOperationObject object) {
        this.objectCount.incrementAndGet();
        try {
            Map<String, String> result = this.tableService.executeTableMaintenanceOperation(this.principal, object.catalogName(), object.namespaceName(), object.objectName(), object.objectId(), this.operationFactory, this.operationContext);
            this.aggregator.addResult(result);
        }
        catch (Exception e) {
            this.addObjectError(object, e.getMessage());
        }
    }

    @Override
    public void complete(Throwable exception) {
        this.future.complete(this.createResult(exception != null ? exception.getMessage() : null));
    }

    public UUID engineId() {
        return this.session.engineId();
    }

    public void cancel(String reason) {
        this.complete(new CancellationException(reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectError(MaintenanceOperationObject object, String error) {
        boolean cancel;
        MaintenanceOperation maintenanceOperation = this;
        synchronized (maintenanceOperation) {
            if (this.objectErrors == null) {
                this.objectErrors = new HashMap<String, String>();
            }
            this.objectErrors.put(String.format("%s.%s.%s", object.catalogName(), object.namespaceName(), object.objectName()), error);
            cancel = this.objectErrors.size() > this.maxErrors;
        }
        if (cancel) {
            this.complete(new CancellationException("Maximum number of errors exceeded"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaintenanceOperationResult createResult(String error) {
        ImmutableMap objectErrors;
        MaintenanceOperation maintenanceOperation = this;
        synchronized (maintenanceOperation) {
            objectErrors = this.objectErrors != null ? ImmutableMap.copyOf(this.objectErrors) : null;
        }
        return new MaintenanceOperationResult(MaintenanceOperation.createFinalResult(this.aggregator, this.objectCount.get()), (Map<String, String>)objectErrors, error);
    }

    private static Map<String, String> createFinalResult(ComputeEngineResultAggregator aggregator, long objectCount) {
        Map operationResult = aggregator.reduce();
        ImmutableMap.Builder res = ImmutableMap.builder();
        res.putAll(operationResult);
        res.put((Object)"system.processed-objects", (Object)Long.toString(objectCount));
        return res.buildKeepingLast();
    }
}

