/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.config.store;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.File;

public class CatalogJdbcSqliteStoreConfig {
    private File storeSqlitePath = new File("catalog-store/sqlite.db");
    private int storeSqliteBusyTimeout = 60000;

    @NotNull
    public File getStoreSqlitePath() {
        return this.storeSqlitePath;
    }

    @Config(value="store.sqlite.path")
    @ConfigDescription(value="Path to SQLite database file")
    public CatalogJdbcSqliteStoreConfig setStoreSqlitePath(File storeSqlitePath) {
        this.storeSqlitePath = storeSqlitePath;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getStoreSqliteBusyTimeout() {
        return this.storeSqliteBusyTimeout;
    }

    @Config(value="store.sqlite.busy-timeout")
    @ConfigDescription(value="Waiting time when the database file is locked. With small timeout concurrent updates may fail with SQLITE_BUSY error.")
    public CatalogJdbcSqliteStoreConfig setStoreSqliteBusyTimeout(int storeSqliteBusyTimeout) {
        this.storeSqliteBusyTimeout = storeSqliteBusyTimeout;
        return this;
    }
}

