/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.config.store;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import ru.cedrusdata.catalog.store.jdbc.JdbcDatabaseType;

public class CatalogJdbcPostgresqlStoreConfig {
    private String storePostgresqlJdbcUrl;
    private String storePostgresqlUsername;
    private String storePostgresqlPassword;

    @NotEmpty
    public String getStorePostgresqlJdbcUrl() {
        return this.storePostgresqlJdbcUrl;
    }

    @Config(value="store.postgresql.jdbc-url")
    @ConfigDescription(value="JDBC URL to connect to PostgreSQL instance")
    public CatalogJdbcPostgresqlStoreConfig setStorePostgresqlJdbcUrl(String storePostgresqlJdbcUrl) {
        this.storePostgresqlJdbcUrl = storePostgresqlJdbcUrl;
        return this;
    }

    @AssertTrue(message="\"store.postgresql.jdbc-url\" should start with \"jdbc:postgresql\"")
    public @AssertTrue(message="\"store.postgresql.jdbc-url\" should start with \"jdbc:postgresql\"") boolean isStorePostgresqlJdbcUrlValid() {
        return Optional.of(JdbcDatabaseType.POSTGRESQL).equals(JdbcDatabaseType.resolveFromJdbcUrl(this.storePostgresqlJdbcUrl));
    }

    @NotEmpty
    public String getStorePostgresqlUsername() {
        return this.storePostgresqlUsername;
    }

    @Config(value="store.postgresql.username")
    @ConfigDescription(value="Username to connect to PostgreSQL instance")
    public CatalogJdbcPostgresqlStoreConfig setStorePostgresqlUsername(String storePostgresqlUsername) {
        this.storePostgresqlUsername = storePostgresqlUsername;
        return this;
    }

    @NotNull
    public Optional<String> getStorePostgresqlPassword() {
        return Optional.ofNullable(this.storePostgresqlPassword);
    }

    @Config(value="store.postgresql.password")
    @ConfigDescription(value="Password to connect to PostgreSQL instance")
    @ConfigSecuritySensitive
    public CatalogJdbcPostgresqlStoreConfig setStorePostgresqlPassword(String storePostgresqlPassword) {
        this.storePostgresqlPassword = storePostgresqlPassword;
        return this;
    }
}

