/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigHidden;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.tracing.TracingMode;
import ru.cedrusdata.catalog.tracing.TracingModes;

public class CatalogConfig {
    private static final Splitter NAME_SPLITTER = Splitter.on((char)'|').trimResults().omitEmptyStrings();
    public static final String ADMIN_PRINCIPAL = "admin-principal";
    public static final String ADMIN_PASSWORD = "admin-password";
    private String dataDir = Paths.get("", new String[0]).toAbsolutePath().toString();
    private File resourceDir = new File("resource");
    private File pluginDir = new File("plugin");
    private String adminPrincipal = "root";
    private String adminPassword;
    private File adminAccessTokenFilePath = new File("catalog-admin-access-token");
    private Duration jwtTokenTtl = Duration.valueOf((String)"1h");
    private Optional<String> jwtStateKey = Optional.empty();
    private File jwtGeneratedStateKeyPath = new File("catalog-jwt-state-key");
    private Integer jmxRemotePort;
    private Integer jmxRemoteRmiPort;
    private boolean jmxStrictNameCheck;
    private boolean openmetricsEnabled = true;
    private List<ObjectName> openmetricsJmxObjectNames = ImmutableList.of();
    private boolean openmetricsInsecure;
    public List<TracingMode> telemetryEnabled = List.of();
    private double telemetrySamplingRatio = 1.0;
    private String telemetryExporterEndpoint = "http://localhost:4317";

    public String getDataDir() {
        return this.dataDir;
    }

    @Config(value="data-dir")
    @ConfigDescription(value="Path to a directory with operational data files")
    public CatalogConfig setDataDir(String dataDir) {
        this.dataDir = dataDir;
        return this;
    }

    @NotNull
    public File getResourceDir() {
        return this.resourceDir;
    }

    @Config(value="resource-dir")
    @ConfigDescription(value="Path to a directory with custom catalog resource files")
    public CatalogConfig setResourceDir(File resourceDir) {
        this.resourceDir = resourceDir;
        return this;
    }

    @NotNull
    public File getPluginDir() {
        return this.pluginDir;
    }

    @Config(value="plugin-dir")
    @ConfigDescription(value="Path to a directory with installed plugins")
    public CatalogConfig setPluginDir(File pluginDir) {
        this.pluginDir = pluginDir;
        return this;
    }

    @NotNull
    public String getAdminPrincipal() {
        return this.adminPrincipal;
    }

    @Config(value="admin-principal")
    @ConfigDescription(value="Name of initial admin principal (created on a server startup or if no other admin exist)")
    public CatalogConfig setAdminPrincipal(String adminPrincipal) {
        this.adminPrincipal = adminPrincipal;
        return this;
    }

    @AssertTrue(message="\"admin-principal\" must contain only alphanumeric characters and underscores")
    public @AssertTrue(message="\"admin-principal\" must contain only alphanumeric characters and underscores") boolean isAdminPrincipalValid() {
        try {
            CatalogObjectNameValidation.VALIDATION_PRINCIPAL.normalizeObjectName(this.adminPrincipal);
            return true;
        }
        catch (CatalogBadRequestException e) {
            return false;
        }
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    @Config(value="admin-password")
    @ConfigDescription(value="Password of an initial admin user (created on a server startup or if no other admin users exist)")
    @ConfigSecuritySensitive
    public CatalogConfig setAdminPassword(String adminPassword) {
        if (adminPassword != null && (adminPassword = adminPassword.trim()).isEmpty()) {
            adminPassword = null;
        }
        this.adminPassword = adminPassword;
        return this;
    }

    @AssertTrue(message="\"admin-password\" length cannot be greater than 72")
    public @AssertTrue(message="\"admin-password\" length cannot be greater than 72") boolean isAdminPasswordValid() {
        return this.adminPassword == null || this.adminPassword.length() <= 72;
    }

    @NotNull
    public File getAdminAccessTokenFilePath() {
        return this.adminAccessTokenFilePath;
    }

    @Config(value="admin-access-token-file-path")
    @ConfigDescription(value="Path to a file where an initial admin access token will be written")
    public CatalogConfig setAdminAccessTokenFilePath(File adminAccessTokenFilePath) {
        this.adminAccessTokenFilePath = adminAccessTokenFilePath;
        return this;
    }

    @MinDuration(value="1s")
    @NotNull
    public @MinDuration(value="1s") @NotNull Duration getJwtTokenTtl() {
        return this.jwtTokenTtl;
    }

    @Config(value="jwt.token-ttl")
    @ConfigDescription(value="JWT token TTL")
    public CatalogConfig setJwtTokenTtl(Duration jwtTokenTtl) {
        this.jwtTokenTtl = jwtTokenTtl;
        return this;
    }

    public Optional<String> getJwtStateKey() {
        return this.jwtStateKey;
    }

    @Config(value="jwt.state-key")
    @ConfigDescription(value="A secret key used by the SHA-256 algorithm to sign JWT tokens. Default is a random string generated during server start")
    @ConfigSecuritySensitive
    public CatalogConfig setJwtStateKey(String jwtStateKey) {
        if (jwtStateKey != null && jwtStateKey.isEmpty()) {
            jwtStateKey = null;
        }
        this.jwtStateKey = Optional.ofNullable(jwtStateKey);
        return this;
    }

    @NotNull
    public File getJwtGeneratedStateKeyPath() {
        return this.jwtGeneratedStateKeyPath;
    }

    @Config(value="jwt.generated-state-key-path")
    @ConfigDescription(value="Path where an automatically generated JWT token will be persisted if \"jwt.state-key\" is not provided")
    public CatalogConfig setJwtGeneratedStateKeyPath(File generatedJwtStateKeyPath) {
        this.jwtGeneratedStateKeyPath = generatedJwtStateKeyPath;
        return this;
    }

    public Integer getJmxRemotePort() {
        return this.jmxRemotePort;
    }

    @Config(value="jmx.remote-port")
    @ConfigDescription(value="Enables the JMX remote agent and creates a remote JMX connector to listen through the specified port")
    public CatalogConfig setJmxRemotePort(Integer jmxRemotePort) {
        this.jmxRemotePort = jmxRemotePort;
        return this;
    }

    public Integer getJmxRemoteRmiPort() {
        return this.jmxRemoteRmiPort;
    }

    @Config(value="jmx.remote-rmi-port")
    @ConfigDescription(value="Specifies the port number to which the RMI connector will be bound")
    public CatalogConfig setJmxRemoteRmiPort(Integer jmxRemoteRmiPort) {
        this.jmxRemoteRmiPort = jmxRemoteRmiPort;
        return this;
    }

    @AssertTrue(message="\"jmx.remote-port\" must be configured when \"jmx.remote-rmi-port\" is set")
    public @AssertTrue(message="\"jmx.remote-port\" must be configured when \"jmx.remote-rmi-port\" is set") boolean isJmxConfigValid() {
        return this.jmxRemoteRmiPort == null || this.jmxRemotePort != null;
    }

    public boolean isJmxStrictNameCheck() {
        return this.jmxStrictNameCheck;
    }

    @Config(value="jmx.strict-name-check")
    @ConfigDescription(value="Enforces string JMX bean name check (for testing only)")
    @ConfigHidden
    public CatalogConfig setJmxStrictNameCheck(boolean jmxStrictNameCheck) {
        this.jmxStrictNameCheck = jmxStrictNameCheck;
        return this;
    }

    public boolean isOpenmetricsEnabled() {
        return this.openmetricsEnabled;
    }

    @Config(value="openmetrics.enabled")
    @ConfigDescription(value="Whether OpenMetrics exporter is enabled")
    public CatalogConfig setOpenmetricsEnabled(boolean openmetricsEnabled) {
        this.openmetricsEnabled = openmetricsEnabled;
        return this;
    }

    public List<ObjectName> getOpenmetricsJmxObjectNames() {
        return this.openmetricsJmxObjectNames;
    }

    @Config(value="openmetrics.jmx-object-names")
    @ConfigDescription(value="JMX object names to include for OpenMetrics exporter when retrieving all metrics, separated by '|'")
    public CatalogConfig setOpenmetricsJmxObjectNames(String names) {
        this.openmetricsJmxObjectNames = (List)NAME_SPLITTER.splitToStream((CharSequence)names).map(CatalogConfig::toObjectName).collect(ImmutableList.toImmutableList());
        return this;
    }

    public CatalogConfig setOpenmetricsJmxObjectNames(List<ObjectName> names) {
        this.openmetricsJmxObjectNames = ImmutableList.copyOf(names);
        return this;
    }

    public boolean isOpenmetricsInsecure() {
        return this.openmetricsInsecure;
    }

    @Config(value="openmetrics.insecure")
    @ConfigDescription(value="Allow anonymous access to OpenMetrics endpoint")
    public CatalogConfig setOpenmetricsInsecure(boolean openmetricsInsecure) {
        this.openmetricsInsecure = openmetricsInsecure;
        return this;
    }

    @NotNull
    public TracingModes getTelemetryEnabled() {
        return TracingModes.merge(this.telemetryEnabled);
    }

    @Config(value="telemetry.enabled")
    @ConfigDescription(value="Whether OpenTelemetry is enabled system-wise or for individual components. Allowed values: ALL, HTTP, API, FILE_SYSTEM, STORE")
    public CatalogConfig setTelemetryEnabled(List<TracingMode> telemetryEnabled) {
        this.telemetryEnabled = telemetryEnabled;
        return this;
    }

    @Max(value=1L)
    @Min(value=0L)
    public @Max(value=1L) @Min(value=0L) double getTelemetrySamplingRatio() {
        return this.telemetrySamplingRatio;
    }

    @Config(value="telemetry.sampling-ratio")
    @ConfigDescription(value="OpenTelemetry sampling ratio")
    public CatalogConfig setTelemetrySamplingRatio(Double telemetrySamplingRatio) {
        this.telemetrySamplingRatio = telemetrySamplingRatio;
        return this;
    }

    @Pattern(regexp="^(http|https)://.*$", message="tracing.exporter.endpoint must start with http:// or https://")
    public @Pattern(regexp="^(http|https)://.*$", message="tracing.exporter.endpoint must start with http:// or https://") String getTelemetryExporterEndpoint() {
        return this.telemetryExporterEndpoint;
    }

    @Config(value="telemetry.exporter-endpoint")
    @ConfigDescription(value="OpenTelemetry exporter endpoint")
    public CatalogConfig setTelemetryExporterEndpoint(String telemetryExporterEndpoint) {
        this.telemetryExporterEndpoint = telemetryExporterEndpoint;
        return this;
    }

    private static ObjectName toObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

