/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.api;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import ru.cedrusdata.catalog.api.JmxEmbeddedInternalCatalogClient;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.iceberg.InternalIcebergCatalogClient;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.iceberg.rest.IcebergOptions;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateTemporaryResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.CheckAccessRequest;
import ru.cedrusdata.catalog.spi.model.CheckAccessResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCheckResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCreateRequest;
import ru.cedrusdata.catalog.spi.model.ComputeEngineInfo;
import ru.cedrusdata.catalog.spi.model.ComputeEngineListResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineUpdateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.GrantOwnershipRequest;
import ru.cedrusdata.catalog.spi.model.GrantPrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.GrantRoleRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCheckResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCteTableForReuseRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCteTableForReuseResponse;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.LabelListResponse;
import ru.cedrusdata.catalog.spi.model.LocaleListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobCreateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobUpdateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupCreateRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupInfo;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemAddRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupObjectListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupUpdateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.PrivilegeGrantsResponse;
import ru.cedrusdata.catalog.spi.model.PrivilegeTypesResponse;
import ru.cedrusdata.catalog.spi.model.PrivilegedActionsResponse;
import ru.cedrusdata.catalog.spi.model.RevokePrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.RevokeRoleRequest;
import ru.cedrusdata.catalog.spi.model.RoleMembersResponse;
import ru.cedrusdata.catalog.spi.model.SecurablePrivilegeGrantsRequest;
import ru.cedrusdata.catalog.spi.model.SecurableTypesResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderCheckResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderCreateRequest;
import ru.cedrusdata.catalog.spi.model.SecurityProviderInfo;
import ru.cedrusdata.catalog.spi.model.SecurityProviderListResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderUpdateRequest;
import ru.cedrusdata.catalog.spi.model.ServerInfo;
import ru.cedrusdata.catalog.spi.model.UpdateResponse;
import ru.cedrusdata.catalog.tracing.TracingAttributes;
import ru.cedrusdata.catalog.tracing.TracingScopedSpan;

public class TracingEmbeddedInternalCatalogClient
implements InternalCatalogClient,
InternalIcebergCatalogClient {
    private final AuthenticationContext context;
    private final JmxEmbeddedInternalCatalogClient delegate;
    private final Tracer tracer;

    public TracingEmbeddedInternalCatalogClient(JmxEmbeddedInternalCatalogClient delegate, Tracer tracer) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.context = delegate.context();
        this.tracer = Objects.requireNonNull(tracer, "tracer");
    }

    public InternalCatalogClient runAs(String subject) {
        Span span = this.startSpan(this.context, ApiType.API, "runAs");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            TracingEmbeddedInternalCatalogClient tracingEmbeddedInternalCatalogClient = new TracingEmbeddedInternalCatalogClient(this.delegate.runAs(subject), this.tracer);
            return tracingEmbeddedInternalCatalogClient;
        }
    }

    public ServerInfo info() {
        Span span = this.startSpan(this.context, ApiType.API, "info");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ServerInfo serverInfo = this.delegate.info();
            return serverInfo;
        }
    }

    public void createPrincipal(PrincipalCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createPrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createPrincipal(request);
        }
    }

    public void updatePrincipal(String principalName, PrincipalUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updatePrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updatePrincipal(principalName, request);
        }
    }

    public void deletePrincipal(String principalName) {
        Span span = this.startSpan(this.context, ApiType.API, "deletePrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deletePrincipal(principalName);
        }
    }

    public PrincipalInfo getPrincipal(String principalName) {
        Span span = this.startSpan(this.context, ApiType.API, "getPrincipal");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrincipalInfo principalInfo = this.delegate.getPrincipal(principalName);
            return principalInfo;
        }
    }

    public PrincipalListResponse listPrincipals(Optional<String> principalType, Optional<Boolean> active, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listPrincipals", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrincipalListResponse principalListResponse = this.delegate.listPrincipals(principalType, active, page);
            return principalListResponse;
        }
    }

    public AccessTokenCreateTemporaryResponse createTemporaryAccessToken() {
        Span span = this.startSpan(this.context, ApiType.API, "createTemporaryAccessToken");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenCreateTemporaryResponse accessTokenCreateTemporaryResponse = this.delegate.createTemporaryAccessToken();
            return accessTokenCreateTemporaryResponse;
        }
    }

    public AccessTokenCreateTemporaryResponse createTemporaryAccessToken(String subject) {
        Span span = this.startSpan(this.context, ApiType.API, "createTemporaryAccessToken");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenCreateTemporaryResponse accessTokenCreateTemporaryResponse = this.delegate.createTemporaryAccessToken(subject);
            return accessTokenCreateTemporaryResponse;
        }
    }

    public AccessTokenCreateResponse createAccessToken(AccessTokenCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createAccessToken");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenCreateResponse accessTokenCreateResponse = this.delegate.createAccessToken(request);
            return accessTokenCreateResponse;
        }
    }

    public void deleteAccessToken(String accessTokenId) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteAccessToken");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteAccessToken(accessTokenId);
        }
    }

    public AccessTokenListResponse listAccessTokens(Optional<String> principalName, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listAccessTokens", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            AccessTokenListResponse accessTokenListResponse = this.delegate.listAccessTokens(principalName, page);
            return accessTokenListResponse;
        }
    }

    public UpdateResponse grantRole(GrantRoleRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "grantRole");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            UpdateResponse updateResponse = this.delegate.grantRole(request);
            return updateResponse;
        }
    }

    public UpdateResponse revokeRole(RevokeRoleRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "revokeRole");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            UpdateResponse updateResponse = this.delegate.revokeRole(request);
            return updateResponse;
        }
    }

    public RoleMembersResponse roleMembers(String roleName) {
        Span span = this.startSpan(this.context, ApiType.API, "roleMembers");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            RoleMembersResponse roleMembersResponse = this.delegate.roleMembers(roleName);
            return roleMembersResponse;
        }
    }

    public UpdateResponse grantPrivilege(GrantPrivilegeRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "grantPrivilege");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            UpdateResponse updateResponse = this.delegate.grantPrivilege(request);
            return updateResponse;
        }
    }

    public UpdateResponse revokePrivilege(RevokePrivilegeRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "revokePrivilege");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            UpdateResponse updateResponse = this.delegate.revokePrivilege(request);
            return updateResponse;
        }
    }

    public PrivilegeGrantsResponse principalPrivilegeGrants(String principal) {
        Span span = this.startSpan(this.context, ApiType.API, "principalPrivilegeGrants");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrivilegeGrantsResponse privilegeGrantsResponse = this.delegate.principalPrivilegeGrants(principal);
            return privilegeGrantsResponse;
        }
    }

    public PrivilegeGrantsResponse securablePrivilegeGrants(SecurablePrivilegeGrantsRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "securablePrivilegeGrants");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrivilegeGrantsResponse privilegeGrantsResponse = this.delegate.securablePrivilegeGrants(request);
            return privilegeGrantsResponse;
        }
    }

    public UpdateResponse grantOwnership(GrantOwnershipRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "grantOwnership");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            UpdateResponse updateResponse = this.delegate.grantOwnership(request);
            return updateResponse;
        }
    }

    public SecurableTypesResponse securableTypes() {
        Span span = this.startSpan(this.context, ApiType.API, "securableTypes");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            SecurableTypesResponse securableTypesResponse = this.delegate.securableTypes();
            return securableTypesResponse;
        }
    }

    public PrivilegeTypesResponse privilegeTypes() {
        Span span = this.startSpan(this.context, ApiType.API, "privilegeTypes");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrivilegeTypesResponse privilegeTypesResponse = this.delegate.privilegeTypes();
            return privilegeTypesResponse;
        }
    }

    public PrivilegedActionsResponse privilegedActions() {
        Span span = this.startSpan(this.context, ApiType.API, "privilegedActions");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            PrivilegedActionsResponse privilegedActionsResponse = this.delegate.privilegedActions();
            return privilegedActionsResponse;
        }
    }

    public CheckAccessResponse checkAccess(CheckAccessRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "checkAccess");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            CheckAccessResponse checkAccessResponse = this.delegate.checkAccess(request);
            return checkAccessResponse;
        }
    }

    public void createFileSystem(FileSystemCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createFileSystem(request);
        }
    }

    public void updateFileSystem(String fileSystemName, FileSystemUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updateFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updateFileSystem(fileSystemName, request);
        }
    }

    public void deleteFileSystem(String fileSystemName) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteFileSystem(fileSystemName);
        }
    }

    public FileSystemInfo getFileSystem(String fileSystemName) {
        Span span = this.startSpan(this.context, ApiType.API, "getFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            FileSystemInfo fileSystemInfo = this.delegate.getFileSystem(fileSystemName);
            return fileSystemInfo;
        }
    }

    public FileSystemListResponse listFileSystems(ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listFileSystems", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            FileSystemListResponse fileSystemListResponse = this.delegate.listFileSystems(page);
            return fileSystemListResponse;
        }
    }

    public FileSystemCheckResponse checkFileSystem(String fileSystemName) {
        Span span = this.startSpan(this.context, ApiType.API, "checkFileSystem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            FileSystemCheckResponse fileSystemCheckResponse = this.delegate.checkFileSystem(fileSystemName);
            return fileSystemCheckResponse;
        }
    }

    public void createIcebergCatalog(IcebergCatalogCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createIcebergCatalog(request);
        }
    }

    public void updateIcebergCatalog(String catalogName, IcebergCatalogUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updateIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updateIcebergCatalog(catalogName, request);
        }
    }

    public void deleteIcebergCatalog(String catalogName) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteIcebergCatalog(catalogName);
        }
    }

    public IcebergCatalogInfo getIcebergCatalog(String catalogName) {
        Span span = this.startSpan(this.context, ApiType.API, "getIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergCatalogInfo icebergCatalogInfo = this.delegate.getIcebergCatalog(catalogName);
            return icebergCatalogInfo;
        }
    }

    public IcebergCatalogListResponse listIcebergCatalogs(ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listIcebergCatalogs", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergCatalogListResponse icebergCatalogListResponse = this.delegate.listIcebergCatalogs(page);
            return icebergCatalogListResponse;
        }
    }

    public IcebergCatalogCheckResponse checkIcebergCatalog(String catalogName) {
        Span span = this.startSpan(this.context, ApiType.API, "checkIcebergCatalog");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergCatalogCheckResponse icebergCatalogCheckResponse = this.delegate.checkIcebergCatalog(catalogName);
            return icebergCatalogCheckResponse;
        }
    }

    public IcebergNamespaceInfo getIcebergNamespace(String catalogName, String namespaceName) {
        Span span = this.startSpan(this.context, ApiType.API, "getIcebergNamespace");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergNamespaceInfo icebergNamespaceInfo = this.delegate.getIcebergNamespace(catalogName, namespaceName);
            return icebergNamespaceInfo;
        }
    }

    public IcebergNamespaceListResponse listIcebergNamespaces(Optional<String> catalogName, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listIcebergNamespaces", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergNamespaceListResponse icebergNamespaceListResponse = this.delegate.listIcebergNamespaces(catalogName, page);
            return icebergNamespaceListResponse;
        }
    }

    public IcebergObjectInfo getIcebergObject(String catalogName, String namespaceName, String objectName) {
        Span span = this.startSpan(this.context, ApiType.API, "getIcebergObject");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergObjectInfo icebergObjectInfo = this.delegate.getIcebergObject(catalogName, namespaceName, objectName);
            return icebergObjectInfo;
        }
    }

    public IcebergObjectListResponse listIcebergObjects(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listIcebergObjects", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergObjectListResponse icebergObjectListResponse = this.delegate.listIcebergObjects(catalogName, namespaceName, objectType, page);
            return icebergObjectListResponse;
        }
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(String catalogName, IcebergMaterializedViewForRewriteListRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "listMaterializedViewsForRewrite");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergMaterializedViewForRewriteListResponse icebergMaterializedViewForRewriteListResponse = this.delegate.listMaterializedViewsForRewrite(catalogName, request);
            return icebergMaterializedViewForRewriteListResponse;
        }
    }

    public IcebergCteTableForReuseResponse getCteTableForReuse(String catalogName, IcebergCteTableForReuseRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "getCteTableForReuse");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            IcebergCteTableForReuseResponse icebergCteTableForReuseResponse = this.delegate.getCteTableForReuse(catalogName, request);
            return icebergCteTableForReuseResponse;
        }
    }

    @Override
    public ConfigResponse restIcebergGetConfig(String catalogName) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "getConfig");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ConfigResponse configResponse = this.delegate.restIcebergGetConfig(catalogName);
            return configResponse;
        }
    }

    @Override
    public CreateNamespaceResponse restIcebergCreateNamespace(String catalogName, CreateNamespaceRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "createNamespace");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            CreateNamespaceResponse createNamespaceResponse = this.delegate.restIcebergCreateNamespace(catalogName, request);
            return createNamespaceResponse;
        }
    }

    @Override
    public UpdateNamespacePropertiesResponse restIcebergUpdateNamespaceProperties(String catalogName, Namespace namespace, UpdateNamespacePropertiesRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "updateNamespaceProperties");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            UpdateNamespacePropertiesResponse updateNamespacePropertiesResponse = this.delegate.restIcebergUpdateNamespaceProperties(catalogName, namespace, request);
            return updateNamespacePropertiesResponse;
        }
    }

    @Override
    public void restIcebergDropNamespace(String catalogName, Namespace namespace) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "dropNamespace");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergDropNamespace(catalogName, namespace);
        }
    }

    @Override
    public void restIcebergNamespaceExists(String catalogName, Namespace namespace) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "namespaceExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergNamespaceExists(catalogName, namespace);
        }
    }

    @Override
    public GetNamespaceResponse restIcebergLoadNamespaceMetadata(String catalogName, Namespace namespace) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "loadNamespaceMetadata");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            GetNamespaceResponse getNamespaceResponse = this.delegate.restIcebergLoadNamespaceMetadata(catalogName, namespace);
            return getNamespaceResponse;
        }
    }

    @Override
    public ListNamespacesResponse restIcebergListNamespaces(String catalogName, Optional<Namespace> parentNamespace, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "listNamespaces", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ListNamespacesResponse listNamespacesResponse = this.delegate.restIcebergListNamespaces(catalogName, parentNamespace, page);
            return listNamespacesResponse;
        }
    }

    @Override
    public LoadTableResponse restIcebergCreateTable(String catalogName, Namespace namespace, CreateTableRequest request, String accessDelegation, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "createTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadTableResponse loadTableResponse = this.delegate.restIcebergCreateTable(catalogName, namespace, request, accessDelegation, icebergOptions);
            return loadTableResponse;
        }
    }

    @Override
    public LoadTableResponse restIcebergRegisterTable(String catalogName, Namespace namespace, RegisterTableRequest request, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "registerTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadTableResponse loadTableResponse = this.delegate.restIcebergRegisterTable(catalogName, namespace, request, icebergOptions);
            return loadTableResponse;
        }
    }

    @Override
    public LoadTableResponse restIcebergUpdateTable(String catalogName, Namespace namespace, String tableName, UpdateTableRequest request, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "updateTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadTableResponse loadTableResponse = this.delegate.restIcebergUpdateTable(catalogName, namespace, tableName, request, icebergOptions);
            return loadTableResponse;
        }
    }

    @Override
    public void restIcebergRenameTable(String catalogName, RenameTableRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "renameTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergRenameTable(catalogName, request);
        }
    }

    @Override
    public void restIcebergDropTable(String catalogName, Namespace namespace, String tableName, boolean purgeRequested, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "dropTable");
        if (span.isRecording()) {
            span.setAttribute(TracingAttributes.ICEBERG_TABLE_PURGE_REQUESTED, (Object)Boolean.toString(purgeRequested));
        }
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergDropTable(catalogName, namespace, tableName, purgeRequested, icebergOptions);
        }
    }

    @Override
    public LoadTableResponse restIcebergLoadTable(String catalogName, Namespace namespace, String tableName, String snapshots, String accessDelegation, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "loadTable");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadTableResponse loadTableResponse = this.delegate.restIcebergLoadTable(catalogName, namespace, tableName, snapshots, accessDelegation, icebergOptions);
            return loadTableResponse;
        }
    }

    @Override
    public void restIcebergTableExists(String catalogName, Namespace namespace, String tableName) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "tableExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergTableExists(catalogName, namespace, tableName);
        }
    }

    @Override
    public ListTablesResponse restIcebergListTables(String catalogName, Namespace namespace, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "listTables", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ListTablesResponse listTablesResponse = this.delegate.restIcebergListTables(catalogName, namespace, page);
            return listTablesResponse;
        }
    }

    @Override
    public LoadViewResponse restIcebergCreateView(String catalogName, Namespace namespace, CreateViewRequest request, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "createView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadViewResponse loadViewResponse = this.delegate.restIcebergCreateView(catalogName, namespace, request, icebergOptions);
            return loadViewResponse;
        }
    }

    @Override
    public LoadViewResponse restIcebergReplaceView(String catalogName, Namespace namespace, String viewName, UpdateTableRequest request, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "replaceView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadViewResponse loadViewResponse = this.delegate.restIcebergReplaceView(catalogName, namespace, viewName, request, icebergOptions);
            return loadViewResponse;
        }
    }

    @Override
    public void restIcebergRenameView(String catalogName, RenameTableRequest request) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "renameView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergRenameView(catalogName, request);
        }
    }

    @Override
    public void restIcebergDropView(String catalogName, Namespace namespace, String viewName, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "dropView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergDropView(catalogName, namespace, viewName, icebergOptions);
        }
    }

    @Override
    public LoadViewResponse restIcebergLoadView(String catalogName, Namespace namespace, String viewName, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "loadView");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadViewResponse loadViewResponse = this.delegate.restIcebergLoadView(catalogName, namespace, viewName, icebergOptions);
            return loadViewResponse;
        }
    }

    @Override
    public void restIcebergViewExists(String catalogName, Namespace namespace, String viewName) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "viewExists");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.restIcebergViewExists(catalogName, namespace, viewName);
        }
    }

    @Override
    public ListTablesResponse restIcebergListViews(String catalogName, Namespace namespace, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "listViews", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ListTablesResponse listTablesResponse = this.delegate.restIcebergListViews(catalogName, namespace, page);
            return listTablesResponse;
        }
    }

    @Override
    public LoadObjectResponse restIcebergLoadObject(String catalogName, Namespace namespace, String objectName, String snapshots, String accessDelegation, IcebergOptions icebergOptions) {
        Span span = this.startSpan(this.context, ApiType.ICEBERG_API, "loadObject");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LoadObjectResponse loadObjectResponse = this.delegate.restIcebergLoadObject(catalogName, namespace, objectName, snapshots, accessDelegation, icebergOptions);
            return loadObjectResponse;
        }
    }

    public MaintenanceOperationStartResponse startMaintenanceOperation(MaintenanceOperationStartRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "startMaintenanceOperation");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            MaintenanceOperationStartResponse maintenanceOperationStartResponse = this.delegate.startMaintenanceOperation(request);
            return maintenanceOperationStartResponse;
        }
    }

    public MaintenanceOperationInfo getMaintenanceOperation(UUID operationId) {
        Span span = this.startSpan(this.context, ApiType.API, "getMaintenanceOperation");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            MaintenanceOperationInfo maintenanceOperationInfo = this.delegate.getMaintenanceOperation(operationId);
            return maintenanceOperationInfo;
        }
    }

    public MaintenanceOperationListResponse listMaintenanceOperations(ResultPage page, Optional<Map<String, Object>> filter) {
        Span span = this.startSpan(this.context, ApiType.API, "listMaintenanceOperations", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            MaintenanceOperationListResponse maintenanceOperationListResponse = this.delegate.listMaintenanceOperations(page, filter);
            return maintenanceOperationListResponse;
        }
    }

    public void cancelMaintenanceOperation(UUID operationId) {
        Span span = this.startSpan(this.context, ApiType.API, "cancelMaintenanceOperation");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.cancelMaintenanceOperation(operationId);
        }
    }

    public void createMaintenanceJob(MaintenanceJobCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createMaintenanceJob");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createMaintenanceJob(request);
        }
    }

    public void updateMaintenanceJob(String jobName, MaintenanceJobUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updateMaintenanceJob");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updateMaintenanceJob(jobName, request);
        }
    }

    public void deleteMaintenanceJob(String jobName) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteMaintenanceJob");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteMaintenanceJob(jobName);
        }
    }

    public MaintenanceJobInfo getMaintenanceJob(String jobName) {
        Span span = this.startSpan(this.context, ApiType.API, "getMaintenanceJob");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            MaintenanceJobInfo maintenanceJobInfo = this.delegate.getMaintenanceJob(jobName);
            return maintenanceJobInfo;
        }
    }

    public MaintenanceJobListResponse listMaintenanceJobs(ResultPage page, Optional<Map<String, Object>> filter) {
        Span span = this.startSpan(this.context, ApiType.API, "listMaintenanceJobs", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            MaintenanceJobListResponse maintenanceJobListResponse = this.delegate.listMaintenanceJobs(page, filter);
            return maintenanceJobListResponse;
        }
    }

    public void createComputeEngine(ComputeEngineCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createComputeEngine");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createComputeEngine(request);
        }
    }

    public ComputeEngineCheckResponse checkComputeEngine(String computeEngineName) {
        Span span = this.startSpan(this.context, ApiType.API, "checkComputeEngine");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ComputeEngineCheckResponse computeEngineCheckResponse = this.delegate.checkComputeEngine(computeEngineName);
            return computeEngineCheckResponse;
        }
    }

    public ComputeEngineInfo getComputeEngine(String computeEngineName) {
        Span span = this.startSpan(this.context, ApiType.API, "getComputeEngine");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ComputeEngineInfo computeEngineInfo = this.delegate.getComputeEngine(computeEngineName);
            return computeEngineInfo;
        }
    }

    public ComputeEngineListResponse listComputeEngines(ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listComputeEngines", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ComputeEngineListResponse computeEngineListResponse = this.delegate.listComputeEngines(page);
            return computeEngineListResponse;
        }
    }

    public void updateComputeEngine(String computeEngineName, ComputeEngineUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updateComputeEngine");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updateComputeEngine(computeEngineName, request);
        }
    }

    public void deleteComputeEngine(String computeEngineName) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteComputeEngine");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteComputeEngine(computeEngineName);
        }
    }

    public void createObjectGroup(ObjectGroupCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createObjectGroup");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createObjectGroup(request);
        }
    }

    public void updateObjectGroup(String objectGroupName, ObjectGroupUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updateObjectGroup");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.updateObjectGroup(objectGroupName, request);
        }
    }

    public void deleteObjectGroup(String objectGroupName) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteObjectGroup");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteObjectGroup(objectGroupName);
        }
    }

    public ObjectGroupInfo getObjectGroup(String objectGroupName) {
        Span span = this.startSpan(this.context, ApiType.API, "getObjectGroup");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ObjectGroupInfo objectGroupInfo = this.delegate.getObjectGroup(objectGroupName);
            return objectGroupInfo;
        }
    }

    public ObjectGroupListResponse listObjectGroups(ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listObjectGroups", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ObjectGroupListResponse objectGroupListResponse = this.delegate.listObjectGroups(page);
            return objectGroupListResponse;
        }
    }

    public ObjectGroupObjectListResponse listObjectGroupObjects(String objectGroupName, Optional<UUID> itemId, Optional<String> objectType, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listObjectGroupObjects", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ObjectGroupObjectListResponse objectGroupObjectListResponse = this.delegate.listObjectGroupObjects(objectGroupName, itemId, objectType, page);
            return objectGroupObjectListResponse;
        }
    }

    public void addObjectGroupItem(String objectGroupName, ObjectGroupItemAddRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "addObjectGroupItem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.addObjectGroupItem(objectGroupName, request);
        }
    }

    public void deleteObjectGroupItem(String objectGroupName, UUID itemId) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteObjectGroupItem");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteObjectGroupItem(objectGroupName, itemId);
        }
    }

    public ObjectGroupItemListResponse listObjectGroupItems(String objectGroupName, ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listObjectGroupItems", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            ObjectGroupItemListResponse objectGroupItemListResponse = this.delegate.listObjectGroupItems(objectGroupName, page);
            return objectGroupItemListResponse;
        }
    }

    public LocaleListResponse listLocales() {
        Span span = this.startSpan(this.context, ApiType.API, "listLocales");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LocaleListResponse localeListResponse = this.delegate.listLocales();
            return localeListResponse;
        }
    }

    public LabelListResponse listLabels(Locale locale) {
        Span span = this.startSpan(this.context, ApiType.API, "listLabels");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            LabelListResponse labelListResponse = this.delegate.listLabels(locale);
            return labelListResponse;
        }
    }

    public void createSecurityProvider(SecurityProviderCreateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "createSecurityProvider");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.createSecurityProvider(request);
        }
    }

    public UpdateResponse updateSecurityProvider(String securityProviderName, SecurityProviderUpdateRequest request) {
        Span span = this.startSpan(this.context, ApiType.API, "updateSecurityProvider");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            UpdateResponse updateResponse = this.delegate.updateSecurityProvider(securityProviderName, request);
            return updateResponse;
        }
    }

    public void deleteSecurityProvider(String securityProviderName) {
        Span span = this.startSpan(this.context, ApiType.API, "deleteSecurityProvider");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            this.delegate.deleteSecurityProvider(securityProviderName);
        }
    }

    public SecurityProviderCheckResponse checkSecurityProvider(String securityProviderName) {
        Span span = this.startSpan(this.context, ApiType.API, "checkSecurityProvider");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            SecurityProviderCheckResponse securityProviderCheckResponse = this.delegate.checkSecurityProvider(securityProviderName);
            return securityProviderCheckResponse;
        }
    }

    public SecurityProviderInfo getSecurityProvider(String securityProviderName) {
        Span span = this.startSpan(this.context, ApiType.API, "getSecurityProvider");
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            SecurityProviderInfo securityProviderInfo = this.delegate.getSecurityProvider(securityProviderName);
            return securityProviderInfo;
        }
    }

    public SecurityProviderListResponse listSecurityProviders(ResultPage page) {
        Span span = this.startSpan(this.context, ApiType.API, "listSecurityProviders", page);
        try (TracingScopedSpan ignored = TracingScopedSpan.scopedSpan(span);){
            SecurityProviderListResponse securityProviderListResponse = this.delegate.listSecurityProviders(page);
            return securityProviderListResponse;
        }
    }

    private Span startSpan(AuthenticationContext context, ApiType apiType, String methodName) {
        Span span = this.tracer.spanBuilder(apiType.getCaption() + "." + methodName).startSpan();
        if (span.isRecording()) {
            span.setAttribute(TracingAttributes.ACTOR, (Object)context.actor().name());
            span.setAttribute(TracingAttributes.SUBJECT, (Object)context.subject().name());
        }
        return span;
    }

    private Span startSpan(AuthenticationContext context, ApiType apiType, String methodName, ResultPage page) {
        Span span = this.startSpan(context, apiType, methodName);
        if (span.isRecording()) {
            span.setAttribute(TracingAttributes.RESULT_PAGE_LIMIT, (Object)Integer.toString(page.pageSize().orElse(0)));
        }
        return span;
    }

    private static enum ApiType {
        API("api"),
        ICEBERG_API("iceberg-api");

        private final String caption;

        private ApiType(String caption) {
            this.caption = caption;
        }

        private String getCaption() {
            return this.caption;
        }
    }
}

