/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.api;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.core.computeengine.ComputeEngineService;
import ru.cedrusdata.catalog.core.filesystem.FileSystemService;
import ru.cedrusdata.catalog.core.i18n.InternationalizationService;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationService;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupService;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeService;
import ru.cedrusdata.catalog.core.security.provider.SecurityProviderService;
import ru.cedrusdata.catalog.iceberg.InternalIcebergCatalogClient;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespacePropertiesUpdateResult;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceService;
import ru.cedrusdata.catalog.iceberg.rest.IcebergOptions;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableService;
import ru.cedrusdata.catalog.server.ServerInitializationInfo;
import ru.cedrusdata.catalog.server.ServerVersion;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.exception.CatalogUnsupportedOperationException;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateTemporaryResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.CheckAccessRequest;
import ru.cedrusdata.catalog.spi.model.CheckAccessResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCheckResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCreateRequest;
import ru.cedrusdata.catalog.spi.model.ComputeEngineInfo;
import ru.cedrusdata.catalog.spi.model.ComputeEngineListResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineUpdateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.GrantOwnershipRequest;
import ru.cedrusdata.catalog.spi.model.GrantPrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.GrantRoleRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCheckResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCteTableForReuseRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCteTableForReuseResponse;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.LabelListResponse;
import ru.cedrusdata.catalog.spi.model.LocaleListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobCreateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobUpdateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupCreateRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupInfo;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemAddRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupObjectListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupUpdateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.PrivilegeGrantsResponse;
import ru.cedrusdata.catalog.spi.model.PrivilegeTypesResponse;
import ru.cedrusdata.catalog.spi.model.PrivilegedActionsResponse;
import ru.cedrusdata.catalog.spi.model.RevokePrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.RevokeRoleRequest;
import ru.cedrusdata.catalog.spi.model.RoleMembersResponse;
import ru.cedrusdata.catalog.spi.model.SecurablePrivilegeGrantsRequest;
import ru.cedrusdata.catalog.spi.model.SecurableTypesResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderCheckResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderCreateRequest;
import ru.cedrusdata.catalog.spi.model.SecurityProviderInfo;
import ru.cedrusdata.catalog.spi.model.SecurityProviderListResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderUpdateRequest;
import ru.cedrusdata.catalog.spi.model.ServerInfo;
import ru.cedrusdata.catalog.spi.model.UpdateResponse;

public class EmbeddedInternalCatalogClient
implements InternalCatalogClient,
InternalIcebergCatalogClient {
    private final AuthenticationContext context;
    private final ServerVersion serverVersion;
    private final ServerInitializationInfo serverInitializationInfo;
    private final PrincipalService principalService;
    private final PrivilegeService privilegeService;
    private final FileSystemService fileSystemService;
    private final ComputeEngineService computeEngineService;
    private final IcebergCatalogService icebergCatalogService;
    private final IcebergNamespaceService icebergNamespaceService;
    private final IcebergTableService icebergTableService;
    private final ObjectGroupService objectGroupService;
    private final MaintenanceOperationService maintenanceOperationsService;
    private final InternationalizationService internationalizationService;
    private final SecurityProviderService securityProviderService;

    public EmbeddedInternalCatalogClient(AuthenticationContext context, ServerVersion serverVersion, ServerInitializationInfo serverInitializationInfo, PrincipalService principalService, PrivilegeService privilegeService, FileSystemService fileSystemService, IcebergCatalogService icebergCatalogService, IcebergNamespaceService icebergNamespaceService, IcebergTableService icebergTableService, ObjectGroupService objectGroupService, MaintenanceOperationService maintenanceOperationsService, ComputeEngineService computeEngineService, InternationalizationService internationalizationService, SecurityProviderService securityProviderService) {
        this.context = context;
        this.serverVersion = serverVersion;
        this.serverInitializationInfo = serverInitializationInfo;
        this.principalService = principalService;
        this.privilegeService = privilegeService;
        this.fileSystemService = fileSystemService;
        this.icebergCatalogService = icebergCatalogService;
        this.icebergNamespaceService = icebergNamespaceService;
        this.icebergTableService = icebergTableService;
        this.maintenanceOperationsService = maintenanceOperationsService;
        this.computeEngineService = computeEngineService;
        this.objectGroupService = objectGroupService;
        this.internationalizationService = internationalizationService;
        this.securityProviderService = securityProviderService;
    }

    public AuthenticationContext context() {
        return this.context;
    }

    public EmbeddedInternalCatalogClient runAs(String subjectPrincipalName) {
        AuthenticationContext impersonatedContext = this.principalService.impersonate(this.context, subjectPrincipalName);
        return new EmbeddedInternalCatalogClient(impersonatedContext, this.serverVersion, this.serverInitializationInfo, this.principalService, this.privilegeService, this.fileSystemService, this.icebergCatalogService, this.icebergNamespaceService, this.icebergTableService, this.objectGroupService, this.maintenanceOperationsService, this.computeEngineService, this.internationalizationService, this.securityProviderService);
    }

    public ServerInfo info() {
        return new ServerInfo(this.serverVersion.getVersion(), Boolean.valueOf(this.serverInitializationInfo.isInitialized()));
    }

    public void createPrincipal(PrincipalCreateRequest request) {
        this.principalService.createPrincipal(this.context.subject(), request);
    }

    public void updatePrincipal(String principalName, PrincipalUpdateRequest request) {
        this.principalService.updatePrincipal(this.context.subject(), principalName, request);
    }

    public void deletePrincipal(String principalName) {
        this.principalService.deletePrincipal(this.context.subject(), principalName);
    }

    public PrincipalInfo getPrincipal(String principalName) {
        return this.principalService.getPrincipal(this.context.subject(), principalName);
    }

    public PrincipalListResponse listPrincipals(Optional<String> principalType, Optional<Boolean> active, ResultPage page) {
        return this.principalService.listPrincipals(this.context.subject(), principalType, active, page);
    }

    public AccessTokenCreateTemporaryResponse createTemporaryAccessToken() {
        return this.principalService.createTemporaryAccessToken(this.context, this.context.subject().name());
    }

    public AccessTokenCreateTemporaryResponse createTemporaryAccessToken(String subject) {
        return this.principalService.createTemporaryAccessToken(this.context, subject);
    }

    public AccessTokenCreateResponse createAccessToken(AccessTokenCreateRequest request) {
        return this.principalService.createAccessToken(this.context.subject(), request);
    }

    public void deleteAccessToken(String accessTokenId) {
        this.principalService.deleteAccessToken(this.context.subject(), accessTokenId);
    }

    public AccessTokenListResponse listAccessTokens(Optional<String> principalName, ResultPage page) {
        return this.principalService.listAccessTokens(this.context.subject(), principalName, page);
    }

    public UpdateResponse grantRole(GrantRoleRequest request) {
        return this.principalService.grantRole(this.context.subject(), request);
    }

    public UpdateResponse revokeRole(RevokeRoleRequest request) {
        return this.principalService.revokeRole(this.context.subject(), request);
    }

    public RoleMembersResponse roleMembers(String roleName) {
        return this.principalService.roleMembers(this.context.subject(), roleName);
    }

    public UpdateResponse grantPrivilege(GrantPrivilegeRequest request) {
        return this.privilegeService.grantPrivilege(this.context.subject(), request);
    }

    public UpdateResponse revokePrivilege(RevokePrivilegeRequest request) {
        return this.privilegeService.revokePrivilege(this.context.subject(), request);
    }

    public PrivilegeGrantsResponse principalPrivilegeGrants(String principal) {
        return this.privilegeService.principalPrivilegeGrants(this.context.subject(), principal);
    }

    public PrivilegeGrantsResponse securablePrivilegeGrants(SecurablePrivilegeGrantsRequest request) {
        return this.privilegeService.securablePrivilegeGrants(this.context.subject(), request);
    }

    public UpdateResponse grantOwnership(GrantOwnershipRequest request) {
        return this.privilegeService.grantOwnership(this.context.subject(), request);
    }

    public SecurableTypesResponse securableTypes() {
        return this.privilegeService.securableTypes();
    }

    public PrivilegeTypesResponse privilegeTypes() {
        return this.privilegeService.privilegeTypes();
    }

    public PrivilegedActionsResponse privilegedActions() {
        return this.privilegeService.privilegedActions();
    }

    public CheckAccessResponse checkAccess(CheckAccessRequest request) {
        return this.privilegeService.checkAccess(this.context, request);
    }

    public void createFileSystem(FileSystemCreateRequest request) {
        this.fileSystemService.createFileSystem(this.context.subject(), request);
    }

    public void updateFileSystem(String fileSystemName, FileSystemUpdateRequest request) {
        this.fileSystemService.updateFileSystem(this.context.subject(), fileSystemName, request);
    }

    public void deleteFileSystem(String fileSystemName) {
        this.fileSystemService.deleteFileSystem(this.context.subject(), fileSystemName);
    }

    public FileSystemInfo getFileSystem(String fileSystemName) {
        return this.fileSystemService.info(this.context.subject(), fileSystemName);
    }

    public FileSystemListResponse listFileSystems(ResultPage page) {
        return this.fileSystemService.listFileSystems(this.context.subject(), page);
    }

    public FileSystemCheckResponse checkFileSystem(String fileSystemName) {
        return this.fileSystemService.check(this.context.subject(), fileSystemName);
    }

    public void createIcebergCatalog(IcebergCatalogCreateRequest request) {
        this.icebergCatalogService.create(this.context.subject(), request);
    }

    public void updateIcebergCatalog(String catalogName, IcebergCatalogUpdateRequest request) {
        this.icebergCatalogService.update(this.context.subject(), catalogName, request);
    }

    public void deleteIcebergCatalog(String catalogName) {
        this.icebergCatalogService.delete(this.context.subject(), catalogName);
    }

    public IcebergCatalogInfo getIcebergCatalog(String catalogName) {
        return this.icebergCatalogService.info(this.context.subject(), catalogName);
    }

    public IcebergCatalogListResponse listIcebergCatalogs(ResultPage page) {
        return this.icebergCatalogService.listInfo(this.context.subject(), page);
    }

    public IcebergCatalogCheckResponse checkIcebergCatalog(String catalogName) {
        return this.icebergCatalogService.check(this.context.subject(), catalogName);
    }

    public IcebergNamespaceInfo getIcebergNamespace(String catalogName, String namespaceName) {
        return this.icebergNamespaceService.info(this.context.subject(), catalogName, namespaceName);
    }

    public IcebergNamespaceListResponse listIcebergNamespaces(Optional<String> catalogName, ResultPage page) {
        return this.icebergNamespaceService.list(this.context.subject(), catalogName, page);
    }

    public IcebergObjectInfo getIcebergObject(String catalogName, String namespaceName, String objectName) {
        return this.icebergTableService.info(this.context.subject(), catalogName, namespaceName, objectName);
    }

    public IcebergObjectListResponse listIcebergObjects(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page) {
        return this.icebergTableService.list(this.context.subject(), catalogName, namespaceName, objectType, page);
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(String catalogName, IcebergMaterializedViewForRewriteListRequest request) {
        return this.icebergTableService.listMaterializedViewsForRewrite(this.context.subject(), catalogName, request.getTableNames());
    }

    public IcebergCteTableForReuseResponse getCteTableForReuse(String catalogName, IcebergCteTableForReuseRequest request) {
        return this.icebergTableService.cteTableForReuse(this.context.subject(), catalogName, request.getCanonicalPlan(), request.getMinRemainingTtl());
    }

    @Override
    public ConfigResponse restIcebergGetConfig(String catalogName) {
        return this.icebergCatalogService.getRestConfig(this.context.subject(), catalogName);
    }

    @Override
    public CreateNamespaceResponse restIcebergCreateNamespace(String catalogName, CreateNamespaceRequest request) {
        IcebergNamespaceDetails namespaceInfo = this.icebergNamespaceService.restCreate(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(request.namespace()), request.properties());
        return CreateNamespaceResponse.builder().withNamespace(Namespace.of((String[])new String[]{namespaceInfo.namespaceName()})).setProperties(namespaceInfo.properties()).build();
    }

    @Override
    public UpdateNamespacePropertiesResponse restIcebergUpdateNamespaceProperties(String catalogName, Namespace namespace, UpdateNamespacePropertiesRequest request) {
        IcebergNamespacePropertiesUpdateResult result = this.icebergNamespaceService.restUpdateProperties(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), request.updates(), request.removals());
        HashSet missing = new HashSet(request.removals());
        missing.removeAll(result.removed());
        return UpdateNamespacePropertiesResponse.builder().addUpdated(result.updated()).addRemoved(result.removed()).addMissing(missing).build();
    }

    @Override
    public void restIcebergDropNamespace(String catalogName, Namespace namespace) {
        this.icebergNamespaceService.restDelete(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace));
    }

    @Override
    public void restIcebergNamespaceExists(String catalogName, Namespace namespace) {
        this.icebergNamespaceService.restExists(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace));
    }

    @Override
    public GetNamespaceResponse restIcebergLoadNamespaceMetadata(String catalogName, Namespace namespace) {
        return this.icebergNamespaceService.restLoadMetadata(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace));
    }

    @Override
    public ListNamespacesResponse restIcebergListNamespaces(String catalogName, Optional<Namespace> parentNamespace, ResultPage page) {
        return this.icebergNamespaceService.restList(this.context.subject(), catalogName, parentNamespace.map(CatalogUtils::flattenIcebergNamespace), page);
    }

    @Override
    public LoadTableResponse restIcebergCreateTable(String catalogName, Namespace namespace, CreateTableRequest request, String accessDelegation, IcebergOptions icebergOptions) {
        if (accessDelegation != null) {
            throw new CatalogUnsupportedOperationException("X-Iceberg-Access-Delegation is not supported");
        }
        return this.icebergTableService.restCreateTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), request, icebergOptions);
    }

    @Override
    public LoadTableResponse restIcebergRegisterTable(String catalogName, Namespace namespace, RegisterTableRequest request, IcebergOptions icebergOptions) {
        return this.icebergTableService.restRegisterTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), request, icebergOptions);
    }

    @Override
    public LoadTableResponse restIcebergUpdateTable(String catalogName, Namespace namespace, String tableName, UpdateTableRequest request, IcebergOptions icebergOptions) {
        return this.icebergTableService.restUpdateTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), tableName, request, icebergOptions);
    }

    @Override
    public void restIcebergRenameTable(String catalogName, RenameTableRequest request) {
        this.icebergTableService.restRenameTable(this.context.subject(), catalogName, request);
    }

    @Override
    public void restIcebergDropTable(String catalogName, Namespace namespace, String tableName, boolean purgeRequested, IcebergOptions icebergOptions) {
        this.icebergTableService.restDropTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), tableName, purgeRequested, icebergOptions);
    }

    @Override
    public LoadTableResponse restIcebergLoadTable(String catalogName, Namespace namespace, String tableName, String snapshots, String accessDelegation, IcebergOptions icebergOptions) {
        if (accessDelegation != null) {
            throw new CatalogUnsupportedOperationException("X-Iceberg-Access-Delegation is not supported");
        }
        return this.icebergTableService.restLoadTable(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), tableName, icebergOptions);
    }

    @Override
    public void restIcebergTableExists(String catalogName, Namespace namespace, String tableName) {
        this.icebergTableService.restTableExists(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), tableName);
    }

    @Override
    public ListTablesResponse restIcebergListTables(String catalogName, Namespace namespace, ResultPage page) {
        return this.icebergTableService.restListTables(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), page);
    }

    @Override
    public LoadViewResponse restIcebergCreateView(String catalogName, Namespace namespace, CreateViewRequest request, IcebergOptions icebergOptions) {
        return this.icebergTableService.restCreateView(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), request, icebergOptions);
    }

    @Override
    public LoadViewResponse restIcebergReplaceView(String catalogName, Namespace namespace, String viewName, UpdateTableRequest request, IcebergOptions icebergOptions) {
        return this.icebergTableService.restUpdateView(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), viewName, request, icebergOptions);
    }

    @Override
    public void restIcebergRenameView(String catalogName, RenameTableRequest request) {
        this.icebergTableService.restRenameView(this.context.subject(), catalogName, request);
    }

    @Override
    public void restIcebergDropView(String catalogName, Namespace namespace, String viewName, IcebergOptions icebergOptions) {
        this.icebergTableService.restDropView(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), viewName, icebergOptions);
    }

    @Override
    public LoadViewResponse restIcebergLoadView(String catalogName, Namespace namespace, String viewName, IcebergOptions icebergOptions) {
        return this.icebergTableService.restLoadView(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), viewName, icebergOptions);
    }

    @Override
    public void restIcebergViewExists(String catalogName, Namespace namespace, String viewName) {
        this.icebergTableService.restViewExists(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), viewName);
    }

    @Override
    public ListTablesResponse restIcebergListViews(String catalogName, Namespace namespace, ResultPage page) {
        return this.icebergTableService.restListViews(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), page);
    }

    @Override
    public LoadObjectResponse restIcebergLoadObject(String catalogName, Namespace namespace, String objectName, String snapshots, String accessDelegation, IcebergOptions icebergOptions) {
        if (accessDelegation != null) {
            throw new CatalogUnsupportedOperationException("X-Iceberg-Access-Delegation is not supported");
        }
        return this.icebergTableService.restLoadObject(this.context.subject(), catalogName, CatalogUtils.flattenIcebergNamespace(namespace), objectName, icebergOptions);
    }

    public MaintenanceOperationStartResponse startMaintenanceOperation(MaintenanceOperationStartRequest request) {
        return this.maintenanceOperationsService.startOperation(this.context.subject(), request);
    }

    public MaintenanceOperationInfo getMaintenanceOperation(UUID operationId) {
        return this.maintenanceOperationsService.operationInfo(this.context.subject(), operationId);
    }

    public MaintenanceOperationListResponse listMaintenanceOperations(ResultPage page, Optional<Map<String, Object>> filter) {
        return this.maintenanceOperationsService.listOperations(this.context.subject(), page, filter);
    }

    public void cancelMaintenanceOperation(UUID operationId) {
        this.maintenanceOperationsService.cancelOperation(this.context.subject(), operationId);
    }

    public void createMaintenanceJob(MaintenanceJobCreateRequest request) {
        this.maintenanceOperationsService.createJob(this.context, request);
    }

    public void updateMaintenanceJob(String jobName, MaintenanceJobUpdateRequest request) {
        this.maintenanceOperationsService.updateJob(this.context, jobName, request);
    }

    public void deleteMaintenanceJob(String jobName) {
        this.maintenanceOperationsService.deleteJob(this.context.subject(), jobName);
    }

    public MaintenanceJobInfo getMaintenanceJob(String jobName) {
        return this.maintenanceOperationsService.getJob(this.context.subject(), jobName);
    }

    public MaintenanceJobListResponse listMaintenanceJobs(ResultPage page, Optional<Map<String, Object>> filter) {
        return this.maintenanceOperationsService.listJobs(this.context.subject(), page, filter);
    }

    public void createComputeEngine(ComputeEngineCreateRequest request) {
        this.computeEngineService.createEngine(this.context.subject(), request);
    }

    public ComputeEngineCheckResponse checkComputeEngine(String computeEngineName) {
        return this.computeEngineService.checkEngine(this.context.subject(), computeEngineName);
    }

    public ComputeEngineInfo getComputeEngine(String computeEngineName) {
        return this.computeEngineService.getEngineInfo(this.context.subject(), computeEngineName);
    }

    public ComputeEngineListResponse listComputeEngines(ResultPage page) {
        return this.computeEngineService.listEngines(this.context.subject(), page);
    }

    public void updateComputeEngine(String computeEngineName, ComputeEngineUpdateRequest request) {
        this.computeEngineService.updateEngine(this.context.subject(), computeEngineName, request);
    }

    public void deleteComputeEngine(String computeEngineName) {
        this.computeEngineService.deleteEngine(this.context.subject(), computeEngineName);
    }

    public void createObjectGroup(ObjectGroupCreateRequest request) {
        this.objectGroupService.create(this.context.subject(), request);
    }

    public void updateObjectGroup(String objectGroupName, ObjectGroupUpdateRequest request) {
        this.objectGroupService.update(this.context.subject(), objectGroupName, request);
    }

    public void deleteObjectGroup(String objectGroupName) {
        this.objectGroupService.delete(this.context.subject(), objectGroupName);
    }

    public ObjectGroupInfo getObjectGroup(String objectGroupName) {
        return this.objectGroupService.info(this.context.subject(), objectGroupName);
    }

    public ObjectGroupListResponse listObjectGroups(ResultPage page) {
        return this.objectGroupService.list(this.context.subject(), page);
    }

    public ObjectGroupObjectListResponse listObjectGroupObjects(String objectGroupName, Optional<UUID> itemId, Optional<String> objectType, ResultPage page) {
        return this.objectGroupService.listObjectsForApi(this.context.subject(), objectGroupName, itemId, objectType, page);
    }

    public void addObjectGroupItem(String objectGroupName, ObjectGroupItemAddRequest request) {
        this.objectGroupService.addItem(this.context.subject(), objectGroupName, request);
    }

    public void deleteObjectGroupItem(String objectGroupName, UUID itemId) {
        this.objectGroupService.deleteItem(this.context.subject(), objectGroupName, itemId);
    }

    public ObjectGroupItemListResponse listObjectGroupItems(String objectGroupName, ResultPage page) {
        return this.objectGroupService.listItems(this.context.subject(), objectGroupName, page);
    }

    public LocaleListResponse listLocales() {
        return this.internationalizationService.getLocales();
    }

    public LabelListResponse listLabels(Locale locale) {
        return this.internationalizationService.getLabels(locale);
    }

    public void createSecurityProvider(SecurityProviderCreateRequest request) {
        this.securityProviderService.createProvider(this.context.subject(), request);
    }

    public UpdateResponse updateSecurityProvider(String securityProviderName, SecurityProviderUpdateRequest request) {
        return this.securityProviderService.updateProvider(this.context.subject(), securityProviderName, request);
    }

    public void deleteSecurityProvider(String securityProviderName) {
        this.securityProviderService.deleteProvider(this.context.subject(), securityProviderName);
    }

    public SecurityProviderCheckResponse checkSecurityProvider(String securityProviderName) {
        return this.securityProviderService.checkProvider(this.context.subject(), securityProviderName);
    }

    public SecurityProviderInfo getSecurityProvider(String securityProviderName) {
        return this.securityProviderService.getProvider(this.context.subject(), securityProviderName);
    }

    public SecurityProviderListResponse listSecurityProviders(ResultPage page) {
        return this.securityProviderService.listProviders(this.context.subject(), page);
    }
}

