/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.DataAttribute;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class CompressedQueryDataDecoder
implements QueryDataDecoder {
    protected final QueryDataDecoder delegate;

    public CompressedQueryDataDecoder(QueryDataDecoder delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    abstract InputStream decompress(InputStream var1, int var2) throws IOException;

    @Override
    public Iterable<List<Object>> decode(InputStream stream, DataAttributes metadata) throws IOException {
        Optional<Integer> uncompressedSize = metadata.getOptional(DataAttribute.UNCOMPRESSED_SIZE, Integer.class);
        if (uncompressedSize.isPresent()) {
            return this.delegate.decode(this.decompress(stream, uncompressedSize.get()), metadata);
        }
        return this.delegate.decode(stream, metadata);
    }
}

