/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;

@JsonTypeName(value="PrincipalCreateRequest")
public class PrincipalCreateRequest {
    private final String principalName;
    private final String principalType;
    private final String password;
    private final Boolean active;
    private final String identifiedWith;
    private final Map<String, String> properties;

    @JsonCreator
    public PrincipalCreateRequest(@JsonProperty(value="principal-name") String principalName, @JsonProperty(value="principal-type") String principalType, @JsonProperty(value="password") String password, @JsonProperty(value="active") Boolean active, @JsonProperty(value="identified-with") String identifiedWith, @JsonProperty(value="properties") Map<String, String> properties) {
        this.principalName = principalName;
        this.principalType = principalType;
        this.password = password;
        this.active = active;
        this.identifiedWith = identifiedWith;
        this.properties = properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="principal-name")
    public String getPrincipalName() {
        return this.principalName;
    }

    @JsonProperty(value="principal-type")
    public String getPrincipalType() {
        return this.principalType;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="identified-with")
    public String getIdentifiedWith() {
        return this.identifiedWith;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrincipalCreateRequest principalCreateRequest = (PrincipalCreateRequest)o;
        return Objects.equals(this.principalName, principalCreateRequest.principalName) && Objects.equals(this.principalType, principalCreateRequest.principalType) && Objects.equals(this.password, principalCreateRequest.password) && Objects.equals(this.active, principalCreateRequest.active) && Objects.equals(this.identifiedWith, principalCreateRequest.identifiedWith) && Objects.equals(this.properties, principalCreateRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(this.principalName, this.principalType, this.password, this.active, this.identifiedWith, this.properties);
    }

    public String toString() {
        return "PrincipalCreateRequest{principalName='" + this.principalName + "', principalType='" + this.principalType + "', password='" + this.password + "', active='" + this.active + "', identifiedWith='" + this.identifiedWith + "', properties='" + String.valueOf(this.properties) + "'}";
    }

    public static class Builder {
        private String principalName;
        private String principalType;
        private String password;
        private Boolean active;
        private String identifiedWith;
        private Map<String, String> properties;

        private Builder() {
        }

        public Builder setPrincipalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public Builder setPrincipalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setActive(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder setIdentifiedWith(String identifiedWith) {
            this.identifiedWith = identifiedWith;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public PrincipalCreateRequest build() {
            return new PrincipalCreateRequest(this.principalName, this.principalType, this.password, this.active, this.identifiedWith, this.properties);
        }
    }
}

