/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemInfo;

@JsonTypeName(value="ObjectGroupItemListResponse")
public class ObjectGroupItemListResponse {
    private final List<ObjectGroupItemInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public ObjectGroupItemListResponse(@JsonProperty(value="items") List<ObjectGroupItemInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<ObjectGroupItemInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectGroupItemListResponse objectGroupItemListResponse = (ObjectGroupItemListResponse)o;
        return Objects.equals(this.items, objectGroupItemListResponse.items) && Objects.equals(this.nextPageToken, objectGroupItemListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "ObjectGroupItemListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<ObjectGroupItemInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<ObjectGroupItemInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public ObjectGroupItemListResponse build() {
            return new ObjectGroupItemListResponse(this.items, this.nextPageToken);
        }
    }
}

