/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="ObjectGroupInfo")
public class ObjectGroupInfo {
    private final String groupName;
    private final String catalogName;
    private final String owner;
    private final String description;

    @JsonCreator
    public ObjectGroupInfo(@JsonProperty(value="group-name") String groupName, @JsonProperty(value="catalog-name") String catalogName, @JsonProperty(value="owner") String owner, @JsonProperty(value="description") String description) {
        this.groupName = groupName;
        this.catalogName = catalogName;
        this.owner = owner;
        this.description = description;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="group-name")
    public String getGroupName() {
        return this.groupName;
    }

    @JsonProperty(value="catalog-name")
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectGroupInfo objectGroupInfo = (ObjectGroupInfo)o;
        return Objects.equals(this.groupName, objectGroupInfo.groupName) && Objects.equals(this.catalogName, objectGroupInfo.catalogName) && Objects.equals(this.owner, objectGroupInfo.owner) && Objects.equals(this.description, objectGroupInfo.description);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.catalogName, this.owner, this.description);
    }

    public String toString() {
        return "ObjectGroupInfo{groupName='" + this.groupName + "', catalogName='" + this.catalogName + "', owner='" + this.owner + "', description='" + this.description + "'}";
    }

    public static class Builder {
        private String groupName;
        private String catalogName;
        private String owner;
        private String description;

        private Builder() {
        }

        public Builder setGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public ObjectGroupInfo build() {
            return new ObjectGroupInfo(this.groupName, this.catalogName, this.owner, this.description);
        }
    }
}

