/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="ObjectGroupCreateRequest")
public class ObjectGroupCreateRequest {
    private final String groupName;
    private final String catalogName;
    private final String description;
    private final String namespaceName;
    private final String objectName;

    @JsonCreator
    public ObjectGroupCreateRequest(@JsonProperty(value="group-name") String groupName, @JsonProperty(value="catalog-name") String catalogName, @JsonProperty(value="description") String description, @JsonProperty(value="namespace-name") String namespaceName, @JsonProperty(value="object-name") String objectName) {
        this.groupName = groupName;
        this.catalogName = catalogName;
        this.description = description;
        this.namespaceName = namespaceName;
        this.objectName = objectName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="group-name")
    public String getGroupName() {
        return this.groupName;
    }

    @JsonProperty(value="catalog-name")
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="namespace-name")
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @JsonProperty(value="object-name")
    public String getObjectName() {
        return this.objectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectGroupCreateRequest objectGroupCreateRequest = (ObjectGroupCreateRequest)o;
        return Objects.equals(this.groupName, objectGroupCreateRequest.groupName) && Objects.equals(this.catalogName, objectGroupCreateRequest.catalogName) && Objects.equals(this.description, objectGroupCreateRequest.description) && Objects.equals(this.namespaceName, objectGroupCreateRequest.namespaceName) && Objects.equals(this.objectName, objectGroupCreateRequest.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.catalogName, this.description, this.namespaceName, this.objectName);
    }

    public String toString() {
        return "ObjectGroupCreateRequest{groupName='" + this.groupName + "', catalogName='" + this.catalogName + "', description='" + this.description + "', namespaceName='" + this.namespaceName + "', objectName='" + this.objectName + "'}";
    }

    public static class Builder {
        private String groupName;
        private String catalogName;
        private String description;
        private String namespaceName;
        private String objectName;

        private Builder() {
        }

        public Builder setGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder setObjectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public ObjectGroupCreateRequest build() {
            return new ObjectGroupCreateRequest(this.groupName, this.catalogName, this.description, this.namespaceName, this.objectName);
        }
    }
}

