/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationConfig;

@JsonTypeName(value="MaintenanceOperationInfo")
public class MaintenanceOperationInfo {
    private final UUID operationId;
    private final MaintenanceOperationConfig operationConfig;
    private final String targetObjectGroupName;
    private final String targetCatalogName;
    private final String targetNamespaceName;
    private final String targetObjectName;
    private final String owner;
    private final Long startedAt;
    private final Long completedAt;
    private final Map<String, String> result;
    private final Map<String, String> objectErrors;
    private final String error;
    private final String jobName;

    @JsonCreator
    public MaintenanceOperationInfo(@JsonProperty(value="operation-id") UUID operationId, @JsonProperty(value="operation-config") MaintenanceOperationConfig operationConfig, @JsonProperty(value="target-object-group-name") String targetObjectGroupName, @JsonProperty(value="target-catalog-name") String targetCatalogName, @JsonProperty(value="target-namespace-name") String targetNamespaceName, @JsonProperty(value="target-object-name") String targetObjectName, @JsonProperty(value="owner") String owner, @JsonProperty(value="started-at") Long startedAt, @JsonProperty(value="completed-at") Long completedAt, @JsonProperty(value="result") Map<String, String> result, @JsonProperty(value="objectErrors") Map<String, String> objectErrors, @JsonProperty(value="error") String error, @JsonProperty(value="job-name") String jobName) {
        this.operationId = operationId;
        this.operationConfig = operationConfig;
        this.targetObjectGroupName = targetObjectGroupName;
        this.targetCatalogName = targetCatalogName;
        this.targetNamespaceName = targetNamespaceName;
        this.targetObjectName = targetObjectName;
        this.owner = owner;
        this.startedAt = startedAt;
        this.completedAt = completedAt;
        this.result = result;
        this.objectErrors = objectErrors;
        this.error = error;
        this.jobName = jobName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="operation-id")
    public UUID getOperationId() {
        return this.operationId;
    }

    @JsonProperty(value="operation-config")
    public MaintenanceOperationConfig getOperationConfig() {
        return this.operationConfig;
    }

    @JsonProperty(value="target-object-group-name")
    public String getTargetObjectGroupName() {
        return this.targetObjectGroupName;
    }

    @JsonProperty(value="target-catalog-name")
    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    @JsonProperty(value="target-namespace-name")
    public String getTargetNamespaceName() {
        return this.targetNamespaceName;
    }

    @JsonProperty(value="target-object-name")
    public String getTargetObjectName() {
        return this.targetObjectName;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="started-at")
    public Long getStartedAt() {
        return this.startedAt;
    }

    @JsonProperty(value="completed-at")
    public Long getCompletedAt() {
        return this.completedAt;
    }

    @JsonProperty(value="result")
    public Map<String, String> getResult() {
        return this.result;
    }

    @JsonProperty(value="objectErrors")
    public Map<String, String> getObjectErrors() {
        return this.objectErrors;
    }

    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="job-name")
    public String getJobName() {
        return this.jobName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaintenanceOperationInfo maintenanceOperationInfo = (MaintenanceOperationInfo)o;
        return Objects.equals(this.operationId, maintenanceOperationInfo.operationId) && Objects.equals(this.operationConfig, maintenanceOperationInfo.operationConfig) && Objects.equals(this.targetObjectGroupName, maintenanceOperationInfo.targetObjectGroupName) && Objects.equals(this.targetCatalogName, maintenanceOperationInfo.targetCatalogName) && Objects.equals(this.targetNamespaceName, maintenanceOperationInfo.targetNamespaceName) && Objects.equals(this.targetObjectName, maintenanceOperationInfo.targetObjectName) && Objects.equals(this.owner, maintenanceOperationInfo.owner) && Objects.equals(this.startedAt, maintenanceOperationInfo.startedAt) && Objects.equals(this.completedAt, maintenanceOperationInfo.completedAt) && Objects.equals(this.result, maintenanceOperationInfo.result) && Objects.equals(this.objectErrors, maintenanceOperationInfo.objectErrors) && Objects.equals(this.error, maintenanceOperationInfo.error) && Objects.equals(this.jobName, maintenanceOperationInfo.jobName);
    }

    public int hashCode() {
        return Objects.hash(this.operationId, this.operationConfig, this.targetObjectGroupName, this.targetCatalogName, this.targetNamespaceName, this.targetObjectName, this.owner, this.startedAt, this.completedAt, this.result, this.objectErrors, this.error, this.jobName);
    }

    public String toString() {
        return "MaintenanceOperationInfo{operationId='" + String.valueOf(this.operationId) + "', operationConfig='" + String.valueOf(this.operationConfig) + "', targetObjectGroupName='" + this.targetObjectGroupName + "', targetCatalogName='" + this.targetCatalogName + "', targetNamespaceName='" + this.targetNamespaceName + "', targetObjectName='" + this.targetObjectName + "', owner='" + this.owner + "', startedAt='" + this.startedAt + "', completedAt='" + this.completedAt + "', result='" + String.valueOf(this.result) + "', objectErrors='" + String.valueOf(this.objectErrors) + "', error='" + this.error + "', jobName='" + this.jobName + "'}";
    }

    public static class Builder {
        private UUID operationId;
        private MaintenanceOperationConfig operationConfig;
        private String targetObjectGroupName;
        private String targetCatalogName;
        private String targetNamespaceName;
        private String targetObjectName;
        private String owner;
        private Long startedAt;
        private Long completedAt;
        private Map<String, String> result;
        private Map<String, String> objectErrors;
        private String error;
        private String jobName;

        private Builder() {
        }

        public Builder setOperationId(UUID operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setOperationConfig(MaintenanceOperationConfig operationConfig) {
            this.operationConfig = operationConfig;
            return this;
        }

        public Builder setTargetObjectGroupName(String targetObjectGroupName) {
            this.targetObjectGroupName = targetObjectGroupName;
            return this;
        }

        public Builder setTargetCatalogName(String targetCatalogName) {
            this.targetCatalogName = targetCatalogName;
            return this;
        }

        public Builder setTargetNamespaceName(String targetNamespaceName) {
            this.targetNamespaceName = targetNamespaceName;
            return this;
        }

        public Builder setTargetObjectName(String targetObjectName) {
            this.targetObjectName = targetObjectName;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public Builder setCompletedAt(Long completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public Builder setResult(Map<String, String> result) {
            this.result = result;
            return this;
        }

        public Builder setObjectErrors(Map<String, String> objectErrors) {
            this.objectErrors = objectErrors;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setJobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public MaintenanceOperationInfo build() {
            return new MaintenanceOperationInfo(this.operationId, this.operationConfig, this.targetObjectGroupName, this.targetCatalogName, this.targetNamespaceName, this.targetObjectName, this.owner, this.startedAt, this.completedAt, this.result, this.objectErrors, this.error, this.jobName);
        }
    }
}

