/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobInfo;

@JsonTypeName(value="MaintenanceJobListResponse")
public class MaintenanceJobListResponse {
    private final List<MaintenanceJobInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public MaintenanceJobListResponse(@JsonProperty(value="items") List<MaintenanceJobInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<MaintenanceJobInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaintenanceJobListResponse maintenanceJobListResponse = (MaintenanceJobListResponse)o;
        return Objects.equals(this.items, maintenanceJobListResponse.items) && Objects.equals(this.nextPageToken, maintenanceJobListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "MaintenanceJobListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<MaintenanceJobInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<MaintenanceJobInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public MaintenanceJobListResponse build() {
            return new MaintenanceJobListResponse(this.items, this.nextPageToken);
        }
    }
}

