/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;

@JsonTypeName(value="IcebergObjectListResponse")
public class IcebergObjectListResponse {
    private final List<IcebergObjectInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public IcebergObjectListResponse(@JsonProperty(value="items") List<IcebergObjectInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<IcebergObjectInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergObjectListResponse icebergObjectListResponse = (IcebergObjectListResponse)o;
        return Objects.equals(this.items, icebergObjectListResponse.items) && Objects.equals(this.nextPageToken, icebergObjectListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "IcebergObjectListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<IcebergObjectInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<IcebergObjectInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public IcebergObjectListResponse build() {
            return new IcebergObjectListResponse(this.items, this.nextPageToken);
        }
    }
}

