/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.Set;
import ru.cedrusdata.catalog.spi.model.Securable;

@JsonTypeName(value="GrantPrivilegeRequest")
public class GrantPrivilegeRequest {
    private final String principalName;
    private final Set<String> privileges;
    private final Securable securable;

    @JsonCreator
    public GrantPrivilegeRequest(@JsonProperty(value="principal-name") String principalName, @JsonProperty(value="privileges") Set<String> privileges, @JsonProperty(value="securable") Securable securable) {
        this.principalName = principalName;
        this.privileges = privileges;
        this.securable = securable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="principal-name")
    public String getPrincipalName() {
        return this.principalName;
    }

    @JsonProperty(value="privileges")
    public Set<String> getPrivileges() {
        return this.privileges;
    }

    @JsonProperty(value="securable")
    public Securable getSecurable() {
        return this.securable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantPrivilegeRequest grantPrivilegeRequest = (GrantPrivilegeRequest)o;
        return Objects.equals(this.principalName, grantPrivilegeRequest.principalName) && Objects.equals(this.privileges, grantPrivilegeRequest.privileges) && Objects.equals(this.securable, grantPrivilegeRequest.securable);
    }

    public int hashCode() {
        return Objects.hash(this.principalName, this.privileges, this.securable);
    }

    public String toString() {
        return "GrantPrivilegeRequest{principalName='" + this.principalName + "', privileges='" + String.valueOf(this.privileges) + "', securable='" + String.valueOf(this.securable) + "'}";
    }

    public static class Builder {
        private String principalName;
        private Set<String> privileges;
        private Securable securable;

        private Builder() {
        }

        public Builder setPrincipalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public Builder setPrivileges(Set<String> privileges) {
            this.privileges = privileges;
            return this;
        }

        public Builder setSecurable(Securable securable) {
            this.securable = securable;
            return this;
        }

        public GrantPrivilegeRequest build() {
            return new GrantPrivilegeRequest(this.principalName, this.privileges, this.securable);
        }
    }
}

