/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.Securable;

@JsonTypeName(value="GrantOwnershipRequest")
public class GrantOwnershipRequest {
    private final Securable securable;
    private final String newOwnerName;

    @JsonCreator
    public GrantOwnershipRequest(@JsonProperty(value="securable") Securable securable, @JsonProperty(value="new-owner-name") String newOwnerName) {
        this.securable = securable;
        this.newOwnerName = newOwnerName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="securable")
    public Securable getSecurable() {
        return this.securable;
    }

    @JsonProperty(value="new-owner-name")
    public String getNewOwnerName() {
        return this.newOwnerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantOwnershipRequest grantOwnershipRequest = (GrantOwnershipRequest)o;
        return Objects.equals(this.securable, grantOwnershipRequest.securable) && Objects.equals(this.newOwnerName, grantOwnershipRequest.newOwnerName);
    }

    public int hashCode() {
        return Objects.hash(this.securable, this.newOwnerName);
    }

    public String toString() {
        return "GrantOwnershipRequest{securable='" + String.valueOf(this.securable) + "', newOwnerName='" + this.newOwnerName + "'}";
    }

    public static class Builder {
        private Securable securable;
        private String newOwnerName;

        private Builder() {
        }

        public Builder setSecurable(Securable securable) {
            this.securable = securable;
            return this;
        }

        public Builder setNewOwnerName(String newOwnerName) {
            this.newOwnerName = newOwnerName;
            return this;
        }

        public GrantOwnershipRequest build() {
            return new GrantOwnershipRequest(this.securable, this.newOwnerName);
        }
    }
}

