/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;

@JsonTypeName(value="FileSystemCreateRequest")
public class FileSystemCreateRequest {
    private final String fileSystemName;
    private final String type;
    private final String description;
    private final Map<String, String> properties;

    @JsonCreator
    public FileSystemCreateRequest(@JsonProperty(value="file-system-name") String fileSystemName, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="properties") Map<String, String> properties) {
        this.fileSystemName = fileSystemName;
        this.type = type;
        this.description = description;
        this.properties = properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="file-system-name")
    public String getFileSystemName() {
        return this.fileSystemName;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemCreateRequest fileSystemCreateRequest = (FileSystemCreateRequest)o;
        return Objects.equals(this.fileSystemName, fileSystemCreateRequest.fileSystemName) && Objects.equals(this.type, fileSystemCreateRequest.type) && Objects.equals(this.description, fileSystemCreateRequest.description) && Objects.equals(this.properties, fileSystemCreateRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(this.fileSystemName, this.type, this.description, this.properties);
    }

    public String toString() {
        return "FileSystemCreateRequest{fileSystemName='" + this.fileSystemName + "', type='" + this.type + "', description='" + this.description + "', properties='" + String.valueOf(this.properties) + "'}";
    }

    public static class Builder {
        private String fileSystemName;
        private String type;
        private String description;
        private Map<String, String> properties;

        private Builder() {
        }

        public Builder setFileSystemName(String fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public FileSystemCreateRequest build() {
            return new FileSystemCreateRequest(this.fileSystemName, this.type, this.description, this.properties);
        }
    }
}

