/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationMetadata;

@JsonTypeName(value="ComputeEngineInfo")
public class ComputeEngineInfo {
    private final String computeEngineName;
    private final String type;
    private final String description;
    private final Map<String, String> properties;
    private final Set<String> redactedProperties;
    private final String owner;
    private final List<ComputeEngineOperationMetadata> operations;

    @JsonCreator
    public ComputeEngineInfo(@JsonProperty(value="compute-engine-name") String computeEngineName, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="redactedProperties") Set<String> redactedProperties, @JsonProperty(value="owner") String owner, @JsonProperty(value="operations") List<ComputeEngineOperationMetadata> operations) {
        this.computeEngineName = computeEngineName;
        this.type = type;
        this.description = description;
        this.properties = properties;
        this.redactedProperties = redactedProperties;
        this.owner = owner;
        this.operations = operations;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="compute-engine-name")
    public String getComputeEngineName() {
        return this.computeEngineName;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="redactedProperties")
    public Set<String> getRedactedProperties() {
        return this.redactedProperties;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="operations")
    public List<ComputeEngineOperationMetadata> getOperations() {
        return this.operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputeEngineInfo computeEngineInfo = (ComputeEngineInfo)o;
        return Objects.equals(this.computeEngineName, computeEngineInfo.computeEngineName) && Objects.equals(this.type, computeEngineInfo.type) && Objects.equals(this.description, computeEngineInfo.description) && Objects.equals(this.properties, computeEngineInfo.properties) && Objects.equals(this.redactedProperties, computeEngineInfo.redactedProperties) && Objects.equals(this.owner, computeEngineInfo.owner) && Objects.equals(this.operations, computeEngineInfo.operations);
    }

    public int hashCode() {
        return Objects.hash(this.computeEngineName, this.type, this.description, this.properties, this.redactedProperties, this.owner, this.operations);
    }

    public String toString() {
        return "ComputeEngineInfo{computeEngineName='" + this.computeEngineName + "', type='" + this.type + "', description='" + this.description + "', properties='" + String.valueOf(this.properties) + "', redactedProperties='" + String.valueOf(this.redactedProperties) + "', owner='" + this.owner + "', operations='" + String.valueOf(this.operations) + "'}";
    }

    public static class Builder {
        private String computeEngineName;
        private String type;
        private String description;
        private Map<String, String> properties;
        private Set<String> redactedProperties;
        private String owner;
        private List<ComputeEngineOperationMetadata> operations;

        private Builder() {
        }

        public Builder setComputeEngineName(String computeEngineName) {
            this.computeEngineName = computeEngineName;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setRedactedProperties(Set<String> redactedProperties) {
            this.redactedProperties = redactedProperties;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setOperations(List<ComputeEngineOperationMetadata> operations) {
            this.operations = operations;
            return this;
        }

        public ComputeEngineInfo build() {
            return new ComputeEngineInfo(this.computeEngineName, this.type, this.description, this.properties, this.redactedProperties, this.owner, this.operations);
        }
    }
}

