/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.CatalogException;

public class CatalogRecursiveRoleGrantException
extends CatalogException {
    public static final String PROPERTY_PRINCIPAL_NAME = "principal-name";
    public static final String PROPERTY_ROLE_NAME = "role-name";

    public CatalogRecursiveRoleGrantException(String principalName, String roleName, List<String> roleChain) {
        super(CatalogErrorCode.RECURSIVE_ROLE_GRANT, String.format("Cannot grant role \"%s\" to \"%s\" because of recursion: %s", roleName, principalName, roleChain.stream().map(r -> "\"" + r + "\"").collect(Collectors.joining(" -> "))), Map.of(PROPERTY_PRINCIPAL_NAME, principalName, PROPERTY_ROLE_NAME, roleName));
    }

    public CatalogRecursiveRoleGrantException(String message, Map<String, String> details) {
        super(CatalogErrorCode.RECURSIVE_ROLE_GRANT, message, details);
    }
}

