/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.Map;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCode;
import ru.cedrusdata.catalog.spi.exception.CatalogException;

public class CatalogFileSystemInUseException
extends CatalogException {
    public static final String PROPERTY_FILE_SYSTEM_NAME = "file-system-name";

    public CatalogFileSystemInUseException(String fileSystemName) {
        super(CatalogErrorCode.FILE_SYSTEM_IN_USE, String.format("File system \"%s\" is used by other catalog objects", fileSystemName), Map.of(PROPERTY_FILE_SYSTEM_NAME, fileSystemName));
    }

    public CatalogFileSystemInUseException(String message, Map<String, String> details) {
        super(CatalogErrorCode.FILE_SYSTEM_IN_USE, message, details);
    }
}

