/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.spi.exception.CatalogErrorCodeGroup;

public enum CatalogErrorCode {
    GENERIC_ERROR(CatalogErrorCodeGroup.GENERIC, 1),
    INTERNAL_SERVER_ERROR(CatalogErrorCodeGroup.GENERIC, 2),
    BAD_REQUEST(CatalogErrorCodeGroup.GENERIC, 3),
    AUTHENTICATION_ERROR(CatalogErrorCodeGroup.GENERIC, 4),
    AUTHORIZATION_ERROR(CatalogErrorCodeGroup.GENERIC, 5),
    UNSUPPORTED_OPERATION(CatalogErrorCodeGroup.GENERIC, 6),
    UNPROCESSABLE_ENTITY(CatalogErrorCodeGroup.GENERIC, 7),
    CLIENT_ERROR(CatalogErrorCodeGroup.GENERIC, 8),
    SERVICE_UNAVAILABLE(CatalogErrorCodeGroup.GENERIC, 9),
    PRINCIPAL_DOESNT_EXIST(CatalogErrorCodeGroup.PRINCIPAL, 1),
    PRINCIPAL_ALREADY_EXISTS(CatalogErrorCodeGroup.PRINCIPAL, 2),
    ACCESS_TOKEN_DOESNT_EXIST(CatalogErrorCodeGroup.PRINCIPAL, 3),
    RECURSIVE_ROLE_GRANT(CatalogErrorCodeGroup.PRINCIPAL, 4),
    PRINCIPAL_IN_USE_EXCEPTION(CatalogErrorCodeGroup.PRINCIPAL, 5),
    FILE_SYSTEM_DOESNT_EXIST(CatalogErrorCodeGroup.FILE_SYSTEM, 1),
    FILE_SYSTEM_ALREADY_EXISTS(CatalogErrorCodeGroup.FILE_SYSTEM, 2),
    FILE_SYSTEM_IN_USE(CatalogErrorCodeGroup.FILE_SYSTEM, 3),
    FILE_SYSTEM_STOPPING(CatalogErrorCodeGroup.FILE_SYSTEM, 4),
    FILE_SYSTEM_CHECK_ERROR(CatalogErrorCodeGroup.FILE_SYSTEM, 5),
    ICEBERG_CATALOG_DOESNT_EXIST(CatalogErrorCodeGroup.ICEBERG_CATALOG, 1),
    ICEBERG_CATALOG_ALREADY_EXISTS(CatalogErrorCodeGroup.ICEBERG_CATALOG, 2),
    ICEBERG_CATALOG_IN_USE(CatalogErrorCodeGroup.ICEBERG_CATALOG, 3),
    ICEBERG_CATALOG_CHECK_ERROR(CatalogErrorCodeGroup.ICEBERG_CATALOG, 4),
    ICEBERG_NAMESPACE_DOESNT_EXIST(CatalogErrorCodeGroup.ICEBERG_NAMESPACE, 1),
    ICEBERG_NAMESPACE_ALREADY_EXISTS(CatalogErrorCodeGroup.ICEBERG_NAMESPACE, 2),
    ICEBERG_NAMESPACE_NOT_EMPTY(CatalogErrorCodeGroup.ICEBERG_NAMESPACE, 3),
    OBJECT_GROUP_DOESNT_EXIST(CatalogErrorCodeGroup.OBJECT_GROUP, 1),
    OBJECT_GROUP_ALREADY_EXISTS(CatalogErrorCodeGroup.OBJECT_GROUP, 2),
    OBJECT_GROUP_IN_USE(CatalogErrorCodeGroup.OBJECT_GROUP, 3),
    OBJECT_GROUP_ITEM_DOESNT_EXIST(CatalogErrorCodeGroup.OBJECT_GROUP, 4),
    OBJECT_GROUP_ITEM_ALREADY_EXISTS(CatalogErrorCodeGroup.OBJECT_GROUP, 5),
    ICEBERG_OBJECT_DOESNT_EXIST(CatalogErrorCodeGroup.ICEBERG_OBJECT, 1),
    ICEBERG_OBJECT_ALREADY_EXISTS(CatalogErrorCodeGroup.ICEBERG_OBJECT, 2),
    ICEBERG_OBJECT_COMMIT_FAILED(CatalogErrorCodeGroup.ICEBERG_OBJECT, 3),
    MAINTENANCE_OPERATION_DOESNT_EXIST(CatalogErrorCodeGroup.MAINTENANCE_OPERATION, 1),
    MAINTENANCE_JOB_DOESNT_EXIST(CatalogErrorCodeGroup.MAINTENANCE_JOB, 1),
    MAINTENANCE_JOB_ALREADY_EXIST(CatalogErrorCodeGroup.MAINTENANCE_JOB, 2),
    COMPUTE_ENGINE_DOESNT_EXIST(CatalogErrorCodeGroup.COMPUTE_ENGINE, 1),
    COMPUTE_ENGINE_ALREADY_EXISTS(CatalogErrorCodeGroup.COMPUTE_ENGINE, 2),
    COMPUTE_ENGINE_STOPPING(CatalogErrorCodeGroup.COMPUTE_ENGINE, 3),
    COMPUTE_ENGINE_CHECK_ERROR(CatalogErrorCodeGroup.COMPUTE_ENGINE, 4),
    SECURITY_PROVIDER_DOESNT_EXIST(CatalogErrorCodeGroup.SECURITY_PROVIDER, 1),
    SECURITY_PROVIDER_ALREADY_EXISTS(CatalogErrorCodeGroup.SECURITY_PROVIDER, 2),
    SECURITY_PROVIDER_IN_USE(CatalogErrorCodeGroup.SECURITY_PROVIDER, 3),
    SECURITY_PROVIDER_STOPPING(CatalogErrorCodeGroup.SECURITY_PROVIDER, 4),
    SECURITY_PROVIDER_CHECK_ERROR(CatalogErrorCodeGroup.SECURITY_PROVIDER, 5);

    private static final Map<Integer, CatalogErrorCode> CODE_MAP;
    private final CatalogErrorCodeGroup group;
    private final int code;

    private CatalogErrorCode(CatalogErrorCodeGroup group, int code) {
        this.group = group;
        this.code = group.getCode() * 1000 + code;
    }

    public static CatalogErrorCode fromCode(int code) {
        Optional<CatalogErrorCode> res = CatalogErrorCode.fromCodeOrEmpty(code);
        if (res.isEmpty()) {
            throw new IllegalArgumentException("Unknown error code: " + code);
        }
        return res.get();
    }

    public static Optional<CatalogErrorCode> fromCodeOrEmpty(int code) {
        return Optional.ofNullable(CODE_MAP.get(code));
    }

    public CatalogErrorCodeGroup getGroup() {
        return this.group;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeCaption() {
        return String.format("CCE-%08d", this.code);
    }

    public String toString() {
        return this.getCodeCaption();
    }

    static {
        CODE_MAP = new HashMap<Integer, CatalogErrorCode>();
        for (CatalogErrorCode code : CatalogErrorCode.values()) {
            CatalogErrorCode previousCode = CODE_MAP.put(code.code, code);
            if (previousCode == null) continue;
            throw new IllegalStateException("Conflicting error codes: " + String.valueOf((Object)code) + ", " + String.valueOf((Object)previousCode));
        }
    }
}

