/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.computeengine;

public enum CatalogComputeEngineType {
    LOCAL(-1),
    CEDRUSDATA(0),
    TRINO(1);

    private final int identifier;

    private CatalogComputeEngineType(int identifier) {
        this.identifier = identifier;
    }

    public static CatalogComputeEngineType resolve(int identifier) {
        if (identifier == CatalogComputeEngineType.LOCAL.identifier) {
            return LOCAL;
        }
        if (identifier == CatalogComputeEngineType.CEDRUSDATA.identifier) {
            return CEDRUSDATA;
        }
        if (identifier == CatalogComputeEngineType.TRINO.identifier) {
            return TRINO;
        }
        throw new IllegalArgumentException("Unsupported engine type: " + identifier);
    }

    public int getIdentifier() {
        return this.identifier;
    }
}

