/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Response;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsReceiveRequest;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

enum SqsReceiveRequestAttributesGetter implements MessagingAttributesGetter<SqsReceiveRequest, Response<?>>
{
    INSTANCE;


    public String getSystem(SqsReceiveRequest request) {
        return "AmazonSQS";
    }

    public String getDestination(SqsReceiveRequest request) {
        AmazonWebServiceRequest originalRequest = request.getRequest().getOriginalRequest();
        String queueUrl = RequestAccess.getQueueUrl(originalRequest);
        int i = queueUrl.lastIndexOf(47);
        return i > 0 ? queueUrl.substring(i + 1) : null;
    }

    @Nullable
    public String getDestinationTemplate(SqsReceiveRequest request) {
        return null;
    }

    public boolean isTemporaryDestination(SqsReceiveRequest request) {
        return false;
    }

    public boolean isAnonymousDestination(SqsReceiveRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(SqsReceiveRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageBodySize(SqsReceiveRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageEnvelopeSize(SqsReceiveRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(SqsReceiveRequest request, @Nullable Response<?> response) {
        return null;
    }

    @Nullable
    public String getClientId(SqsReceiveRequest request) {
        return null;
    }

    @Nullable
    public Long getBatchMessageCount(SqsReceiveRequest request, @Nullable Response<?> response) {
        return request.getMessages().size();
    }

    public List<String> getMessageHeader(SqsReceiveRequest request, String name) {
        return StreamSupport.stream(request.getMessages().spliterator(), false).map(message -> message.getMessageAttribute(name)).filter(value -> value != null).collect(Collectors.toList());
    }
}

