CREATE TABLE metastore_security_provider(
    provider_id UUID PRIMARY KEY,
    provider_name VARCHAR NOT NULL UNIQUE,
    provider_type VARCHAR NOT NULL,
    description VARCHAR,
    properties TEXT,
    owner_id UUID,
    FOREIGN KEY (owner_id) REFERENCES metastore_principal(principal_id)
);

ALTER TABLE metastore_principal ADD COLUMN identified_with UUID REFERENCES metastore_security_provider(provider_id);
ALTER TABLE metastore_privilege ADD COLUMN securable_security_provider_id UUID REFERENCES metastore_security_provider(provider_id) ON DELETE CASCADE;

INSERT INTO metastore_privilege_type VALUES ('e515bff3-843d-46fc-b35f-c45d91045a89', 'security-provider.create');
INSERT INTO metastore_privilege_type VALUES ('f2c79528-c4cd-4a9b-a9e5-1c306058a7a4', 'security-provider.usage');
INSERT INTO metastore_privilege_type VALUES ('741d2ba8-a4a9-44f1-bc0e-19a82f654810', 'security-provider.alter');
INSERT INTO metastore_privilege_type VALUES ('f86fc569-1421-4d20-9e5a-ebd6b0ea512a', 'security-provider.drop');

INSERT INTO metastore_security_provider (provider_id, provider_name, provider_type, description)
VALUES ('0d1a8124-c1d9-416c-a05e-1e56085e6e16', 'local', 'local', 'CedrusData Catalog') ON CONFLICT DO NOTHING;

UPDATE metastore_principal SET identified_with = '0d1a8124-c1d9-416c-a05e-1e56085e6e16' WHERE principal_type = 0;
