-- Replace maintenance operation engine FK to "CASCADE"
CREATE TABLE metastore_maintenance_operation_new(
    engine_id UUID NOT NULL,
    operation_id UUID PRIMARY KEY,
    operation_name VARCHAR NOT NULL,
    operation_parameters TEXT,
    target_object_group_id UUID,
    target_object_id UUID,
    owner_id UUID,
    started_at BIGINT NOT NULL,
    completed_at BIGINT,
    result TEXT,
    error VARCHAR,
    job_id UUID,
    FOREIGN KEY (engine_id) REFERENCES metastore_compute_engine(engine_id) ON DELETE CASCADE,
    FOREIGN KEY (target_object_group_id) REFERENCES metastore_object_group(group_id) ON DELETE SET NULL,
    FOREIGN KEY (target_object_id) REFERENCES metastore_iceberg_table(table_id) ON DELETE SET NULL,
    FOREIGN KEY (owner_id) REFERENCES metastore_principal(principal_id) ON DELETE SET NULL,
    FOREIGN KEY (job_id) REFERENCES metastore_maintenance_job(job_id) ON DELETE SET NULL
);

INSERT INTO metastore_maintenance_operation_new(
    engine_id,
    operation_id,
    operation_name,
    operation_parameters,
    target_object_group_id,
    target_object_id,
    owner_id,
    started_at,
    completed_at,
    result,
    error,
    job_id)
SELECT
    engine_id,
    operation_id,
    operation_name,
    operation_parameters,
    target_object_group_id,
    target_object_id,
    owner_id,
    started_at,
    completed_at,
    result,
    error,
    job_id
FROM metastore_maintenance_operation
WHERE engine_id IS NOT NULL;

DROP TABLE metastore_maintenance_operation;

ALTER TABLE metastore_maintenance_operation_new RENAME TO metastore_maintenance_operation;

CREATE INDEX metastore_maintenance_operation_idx_job_id_started_at ON metastore_maintenance_operation(job_id, started_at DESC);
