CREATE TABLE catalog_role_grant(
    principal_id UUID,
    role_id UUID,
    PRIMARY KEY (principal_id, role_id),
    FOREIGN KEY (principal_id) REFERENCES catalog_principal(principal_id) ON DELETE CASCADE,
    FOREIGN KEY (role_id) REFERENCES catalog_role(role_id) ON DELETE CASCADE
);

CREATE INDEX catalog_role_grant_token_idx_principal_id ON catalog_role_grant(principal_id);
CREATE INDEX catalog_role_grant_token_idx_role_id ON catalog_role_grant(role_id);
