/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.hdfs;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.Map;
import org.weakref.jmx.ObjectNameGenerator;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystemJmxObjectNameGenerator;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;
import ru.cedrusdata.catalog.spi.jmx.CatalogJmxNameCheck;

public class CatalogHdfsFileSystemJmxObjectNameGeneratorModule
implements Module {
    private static final Map<String, String> DOMAIN_REMAPPING = Map.of("io.trino.hdfs", "cedrusdata.catalog.plugin.filesystem.hdfs");
    private static final Map<String, String> CLASS_REMAPPING = Map.of("TrinoHdfsFileSystemStats", "HdfsFileSystemStats", "TrinoFileSystemCacheStats", "HdfsFileSystemCacheStats");
    private final String fileSystemName;

    public CatalogHdfsFileSystemJmxObjectNameGeneratorModule(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    public ObjectNameGenerator getObjectNameGenerator(CatalogJmxNameCheck jmxNameCheck) {
        return new CatalogTrinoFileSystemJmxObjectNameGenerator(CatalogFileSystemType.HDFS, this.fileSystemName, DOMAIN_REMAPPING, CLASS_REMAPPING, jmxNameCheck.isStrictNameCheck());
    }
}

