/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.DoNotCall;
import io.trino.spi.Experimental;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Experimental(eta="2022-10-31")
public class FunctionDependencyDeclaration {
    public static final FunctionDependencyDeclaration NO_DEPENDENCIES = FunctionDependencyDeclaration.builder().build();
    private final Set<TypeSignature> typeDependencies;
    private final Set<FunctionDependency> functionDependencies;
    private final Set<OperatorDependency> operatorDependencies;
    private final Set<CastDependency> castDependencies;

    public static FunctionDependencyDeclarationBuilder builder() {
        return new FunctionDependencyDeclarationBuilder();
    }

    private FunctionDependencyDeclaration(Set<TypeSignature> typeDependencies, Set<FunctionDependency> functionDependencies, Set<OperatorDependency> operatorDependencies, Set<CastDependency> castDependencies) {
        this.typeDependencies = Set.copyOf((Collection)Objects.requireNonNull(typeDependencies, "typeDependencies is null"));
        this.functionDependencies = Set.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
        this.operatorDependencies = Set.copyOf((Collection)Objects.requireNonNull(operatorDependencies, "operatorDependencies is null"));
        this.castDependencies = Set.copyOf((Collection)Objects.requireNonNull(castDependencies, "castDependencies is null"));
    }

    @JsonProperty
    public Set<TypeSignature> getTypeDependencies() {
        return this.typeDependencies;
    }

    @JsonProperty
    public Set<FunctionDependency> getFunctionDependencies() {
        return this.functionDependencies;
    }

    @JsonProperty
    public Set<OperatorDependency> getOperatorDependencies() {
        return this.operatorDependencies;
    }

    @JsonProperty
    public Set<CastDependency> getCastDependencies() {
        return this.castDependencies;
    }

    @JsonCreator
    @DoNotCall
    public static FunctionDependencyDeclaration fromJson(@JsonProperty Set<TypeSignature> typeDependencies, @JsonProperty Set<FunctionDependency> functionDependencies, @JsonProperty Set<OperatorDependency> operatorDependencies, @JsonProperty Set<CastDependency> castDependencies) {
        return new FunctionDependencyDeclaration(typeDependencies, functionDependencies, operatorDependencies, castDependencies);
    }

    public static final class FunctionDependencyDeclarationBuilder {
        private final Set<TypeSignature> typeDependencies = new LinkedHashSet<TypeSignature>();
        private final Set<FunctionDependency> functionDependencies = new LinkedHashSet<FunctionDependency>();
        private final Set<OperatorDependency> operatorDependencies = new LinkedHashSet<OperatorDependency>();
        private final Set<CastDependency> castDependencies = new LinkedHashSet<CastDependency>();

        private FunctionDependencyDeclarationBuilder() {
        }

        public FunctionDependencyDeclarationBuilder addType(TypeSignature typeSignature) {
            this.typeDependencies.add(typeSignature);
            return this;
        }

        public FunctionDependencyDeclarationBuilder addFunction(CatalogSchemaFunctionName name, List<Type> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes.stream().map(Type::getTypeSignature).toList(), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addFunctionSignature(CatalogSchemaFunctionName name, List<TypeSignature> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalFunction(CatalogSchemaFunctionName name, List<Type> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes.stream().map(Type::getTypeSignature).toList(), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalFunctionSignature(CatalogSchemaFunctionName name, List<TypeSignature> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes, true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOperator(OperatorType operatorType, List<Type> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes.stream().map(Type::getTypeSignature).toList(), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOperatorSignature(OperatorType operatorType, List<TypeSignature> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalOperator(OperatorType operatorType, List<Type> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes.stream().map(Type::getTypeSignature).toList(), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalOperatorSignature(OperatorType operatorType, List<TypeSignature> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes, true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addCast(Type fromType, Type toType) {
            this.castDependencies.add(new CastDependency(fromType.getTypeSignature(), toType.getTypeSignature(), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addCastSignature(TypeSignature fromType, TypeSignature toType) {
            this.castDependencies.add(new CastDependency(fromType, toType, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalCast(Type fromType, Type toType) {
            this.castDependencies.add(new CastDependency(fromType.getTypeSignature(), toType.getTypeSignature(), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalCastSignature(TypeSignature fromType, TypeSignature toType) {
            this.castDependencies.add(new CastDependency(fromType, toType, true));
            return this;
        }

        public FunctionDependencyDeclaration build() {
            return new FunctionDependencyDeclaration(this.typeDependencies, this.functionDependencies, this.operatorDependencies, this.castDependencies);
        }
    }

    public static final class CastDependency {
        private final TypeSignature fromType;
        private final TypeSignature toType;
        private final boolean optional;

        private CastDependency(TypeSignature fromType, TypeSignature toType, boolean optional) {
            this.fromType = fromType;
            this.toType = toType;
            this.optional = optional;
        }

        @JsonProperty
        public TypeSignature getFromType() {
            return this.fromType;
        }

        @JsonProperty
        public TypeSignature getToType() {
            return this.toType;
        }

        @JsonProperty
        public boolean isOptional() {
            return this.optional;
        }

        @JsonCreator
        public static CastDependency fromJson(@JsonProperty TypeSignature fromType, @JsonProperty TypeSignature toType, @JsonProperty boolean optional) {
            return new CastDependency(fromType, toType, optional);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CastDependency that = (CastDependency)o;
            return Objects.equals(this.fromType, that.fromType) && Objects.equals(this.toType, that.toType);
        }

        public int hashCode() {
            return Objects.hash(this.fromType, this.toType);
        }

        public String toString() {
            return String.format("cast(%s, %s)", this.fromType, this.toType);
        }
    }

    public static final class OperatorDependency {
        private final OperatorType operatorType;
        private final List<TypeSignature> argumentTypes;
        private final boolean optional;

        private OperatorDependency(OperatorType operatorType, List<TypeSignature> argumentTypes, boolean optional) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.argumentTypes = List.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
            this.optional = optional;
        }

        @JsonProperty
        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        @JsonProperty
        public List<TypeSignature> getArgumentTypes() {
            return this.argumentTypes;
        }

        @JsonProperty
        public boolean isOptional() {
            return this.optional;
        }

        @JsonCreator
        public static OperatorDependency fromJson(@JsonProperty OperatorType operatorType, @JsonProperty List<TypeSignature> argumentTypes, @JsonProperty boolean optional) {
            return new OperatorDependency(operatorType, argumentTypes, optional);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorDependency that = (OperatorDependency)o;
            return this.operatorType == that.operatorType && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.operatorType, this.argumentTypes});
        }

        public String toString() {
            return String.valueOf((Object)this.operatorType) + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    public static final class FunctionDependency {
        private final CatalogSchemaFunctionName name;
        private final List<TypeSignature> argumentTypes;
        private final boolean optional;

        private FunctionDependency(CatalogSchemaFunctionName name, List<TypeSignature> argumentTypes, boolean optional) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.argumentTypes = List.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
            this.optional = optional;
        }

        @JsonProperty
        public CatalogSchemaFunctionName getName() {
            return this.name;
        }

        @JsonProperty
        public List<TypeSignature> getArgumentTypes() {
            return this.argumentTypes;
        }

        @JsonProperty
        public boolean isOptional() {
            return this.optional;
        }

        @JsonCreator
        public static FunctionDependency fromJson(@JsonProperty CatalogSchemaFunctionName name, @JsonProperty List<TypeSignature> argumentTypes, @JsonProperty boolean optional) {
            return new FunctionDependency(name, argumentTypes, optional);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionDependency that = (FunctionDependency)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argumentTypes);
        }

        public String toString() {
            return String.valueOf(this.name) + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }
}

