/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class SystemProperties {
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";

    private SystemProperties() {
    }

    public static synchronized void setJavaSecurityKrb5Conf(String value) {
        SystemProperties.set(JAVA_SECURITY_KRB5_CONF, value);
    }

    public static synchronized void set(String key, String newValue) {
        String currentValue = System.getProperty(key);
        SystemProperties.checkSameValues(key, newValue, currentValue);
        System.setProperty(key, newValue);
    }

    private static void checkSameValues(String key, String newValue, String currentValue) {
        Preconditions.checkState((currentValue == null || Objects.equals(currentValue, newValue) ? 1 : 0) != 0, (String)"Refusing to set system property '%s' to '%s', it is already set to '%s'", (Object)key, (Object)newValue, (Object)currentValue);
    }
}

