/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.jmx;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.jmx.ObjectNameGeneratorConfig;
import io.trino.spi.catalog.CatalogName;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.ObjectNameGenerator;

public class ConnectorObjectNameGeneratorModule
implements Module {
    private final String packageName;
    private final String defaultDomainBase;

    public ConnectorObjectNameGeneratorModule(String packageName, String defaultDomainBase) {
        this.packageName = Objects.requireNonNull(packageName, "packageName is null");
        this.defaultDomainBase = Objects.requireNonNull(defaultDomainBase, "defaultDomainBase is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(ObjectNameGeneratorConfig.class);
    }

    @Provides
    ObjectNameGenerator createPrefixObjectNameGenerator(CatalogName catalogName, ObjectNameGeneratorConfig config) {
        String domainBase = (String)MoreObjects.firstNonNull((Object)config.getDomainBase(), (Object)this.defaultDomainBase);
        return new ConnectorObjectNameGenerator(this.packageName, domainBase, catalogName.toString());
    }

    public static final class ConnectorObjectNameGenerator
    implements ObjectNameGenerator {
        private final String packageName;
        private final String domainBase;
        private final String catalogName;

        public ConnectorObjectNameGenerator(String packageName, String domainBase, String catalogName) {
            this.packageName = packageName;
            this.domainBase = domainBase;
            this.catalogName = catalogName;
        }

        public String generatedNameOf(Class<?> type) {
            return new ObjectNameBuilder(this.toDomain(type)).withProperties((Map)ImmutableMap.builder().put((Object)"type", (Object)type.getSimpleName()).put((Object)"name", (Object)this.catalogName).buildOrThrow()).build();
        }

        public String generatedNameOf(Class<?> type, Map<String, String> properties) {
            return new ObjectNameBuilder(this.toDomain(type)).withProperties((Map)ImmutableMap.builder().putAll(properties).put((Object)"catalog", (Object)this.catalogName).buildOrThrow()).build();
        }

        private String toDomain(Class<?> type) {
            Object domain = type.getPackage().getName();
            if (((String)domain).startsWith(this.packageName)) {
                domain = this.domainBase + ((String)domain).substring(this.packageName.length());
            }
            return domain;
        }
    }
}

