/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.authentication;

import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;

public final class KerberosTicketUtils {
    private static final float TICKET_RENEW_WINDOW = 0.8f;

    private KerberosTicketUtils() {
    }

    public static KerberosTicket getTicketGrantingTicket(Subject subject) {
        Set<KerberosTicket> tickets = subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!KerberosTicketUtils.isOriginalTicketGrantingTicket(ticket)) continue;
            return ticket;
        }
        throw new IllegalArgumentException("kerberos ticket not found in " + String.valueOf(subject));
    }

    public static long getRefreshTime(KerberosTicket ticket) {
        long start = ticket.getStartTime().getTime();
        long end = ticket.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    public static boolean isOriginalTicketGrantingTicket(KerberosTicket ticket) {
        return KerberosTicketUtils.isTicketGrantingServerPrincipal(ticket.getServer());
    }

    private static boolean isTicketGrantingServerPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        return principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }
}

