/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.s3.S3Location;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.model.ObjectStorageClass;
import software.amazon.awssdk.services.s3.model.RestoreStatus;
import software.amazon.awssdk.services.s3.model.S3Object;

final class S3FileIterator
implements FileIterator {
    private final S3Location location;
    private final Iterator<S3Object> iterator;
    private final Location baseLocation;
    private static final String S3_GLACIER_TAG = "s3:glacier";
    private static final String S3_GLACIER_AND_RESTORED_TAG = "s3:glacierRestored";

    public S3FileIterator(S3Location location, Iterator<S3Object> iterator) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
        this.baseLocation = location.baseLocation();
    }

    public boolean hasNext() throws IOException {
        try {
            return this.iterator.hasNext();
        }
        catch (SdkException e) {
            throw new IOException("Failed to list location: " + String.valueOf(this.location), e);
        }
    }

    public FileEntry next() throws IOException {
        try {
            S3Object object = this.iterator.next();
            Verify.verify((boolean)object.key().startsWith(this.location.key()), (String)"S3 listed key [%s] does not start with prefix [%s]", (Object)object.key(), (Object)this.location.key());
            Object tags = ImmutableSet.of();
            if (object.storageClass() == ObjectStorageClass.GLACIER || object.storageClass() == ObjectStorageClass.DEEP_ARCHIVE) {
                tags = new HashSet();
                tags.add(S3_GLACIER_TAG);
                if (Optional.ofNullable(object.restoreStatus()).map(RestoreStatus::restoreExpiryDate).isPresent()) {
                    tags.add(S3_GLACIER_AND_RESTORED_TAG);
                }
                tags = ImmutableSet.copyOf((Collection)tags);
            }
            return new FileEntry(this.baseLocation.appendPath(object.key()), object.size().longValue(), object.lastModified(), Optional.empty(), (Set)tags);
        }
        catch (SdkException e) {
            throw new IOException("Failed to list location: " + String.valueOf(this.location), e);
        }
    }
}

