/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0.internal.RequestHeaderSetter;
import java.io.IOException;

public final class TracingInterceptor
implements Interceptor {
    private final Instrumenter<Request, Response> instrumenter;
    private final ContextPropagators propagators;

    public TracingInterceptor(Instrumenter<Request, Response> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            return chain.proceed(chain.request());
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        request = this.injectContextToRequest(request, context);
        Response response = null;
        Exception error = null;
        try {
            Response response2;
            block12: {
                Scope ignored = context.makeCurrent();
                try {
                    response2 = response = chain.proceed(request);
                    if (ignored == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        error = e;
                        throw e;
                    }
                }
                ignored.close();
            }
            return response2;
        }
        finally {
            this.instrumenter.end(context, (Object)request, (Object)response, (Throwable)error);
        }
    }

    private Request injectContextToRequest(Request request, Context context) {
        Request.Builder requestBuilder = request.newBuilder();
        this.propagators.getTextMapPropagator().inject(context, (Object)requestBuilder, (TextMapSetter)RequestHeaderSetter.INSTANCE);
        return requestBuilder.build();
    }
}

