/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.uri;

import io.trino.jdbc.$internal.airlift.units.Duration;
import io.trino.jdbc.$internal.client.ClientSelectedRole;
import io.trino.jdbc.$internal.client.ClientSession;
import io.trino.jdbc.$internal.client.DnsResolver;
import io.trino.jdbc.$internal.client.auth.external.ExternalRedirectStrategy;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.client.uri.ConnectionProperties;
import io.trino.jdbc.$internal.client.uri.ConnectionProperty;
import io.trino.jdbc.$internal.client.uri.KnownTokenCache;
import io.trino.jdbc.$internal.client.uri.LoggingLevel;
import io.trino.jdbc.$internal.client.uri.PropertyName;
import io.trino.jdbc.$internal.client.uri.RestrictedPropertyException;
import io.trino.jdbc.$internal.guava.annotations.VisibleForTesting;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.base.Strings;
import io.trino.jdbc.$internal.guava.collect.ImmutableCollection;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.collect.ImmutableSet;
import io.trino.jdbc.$internal.guava.net.HostAndPort;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.ietf.jgss.GSSCredential;

public class TrinoUri {
    private static final String URL_START = "trino:";
    public static final int DEFAULT_INSECURE_PORT = 80;
    public static final int DEFAULT_SECURE_PORT = 443;
    private static final Splitter QUERY_SPLITTER = Splitter.on('&').omitEmptyStrings();
    private static final Splitter ARG_SPLITTER = Splitter.on('=').limit(2);
    private static final AtomicReference<RedirectHandler> REDIRECT_HANDLER = new AtomicReference<Object>(null);
    private final URI uri;
    private final List<PropertyName> restrictedProperties;
    private final Properties properties;

    private TrinoUri(List<PropertyName> restrictedProperties, URI uri, Properties explicitProperties) {
        this.restrictedProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(restrictedProperties, "restrictedProperties is null"));
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.properties = this.mergeConnectionProperties(TrinoUri.extractPropertiesFromUri(uri, restrictedProperties), Objects.requireNonNull(explicitProperties, "explicitProperties is null"));
        this.validateConnectionProperties(this.properties);
    }

    protected TrinoUri(String url, Properties properties) {
        this(TrinoUri.parseDriverUrl(url), properties);
    }

    protected TrinoUri(URI uri, Properties driverProperties) {
        this(ImmutableList.of(), uri, driverProperties);
    }

    public static TrinoUri create(String url, Properties properties) {
        return new TrinoUri(url, MoreObjects.firstNonNull(properties, new Properties()));
    }

    public static TrinoUri create(URI uri, Properties properties) {
        return new TrinoUri(uri, MoreObjects.firstNonNull(properties, new Properties()));
    }

    public URI getUri() {
        return this.uri;
    }

    public Optional<Boolean> getSSL() {
        return this.resolveOptional(ConnectionProperties.SSL);
    }

    public Optional<String> getSchema() {
        return this.resolveOptional(ConnectionProperties.SCHEMA);
    }

    public Optional<String> getCatalog() {
        return this.resolveOptional(ConnectionProperties.CATALOG);
    }

    public URI getHttpUri() {
        return URI.create(String.format("%s://%s:%d", this.isUseSecureConnection() ? "https" : "http", this.uri.getHost(), this.getPort()));
    }

    private int getPort() {
        if (this.uri.getPort() > 0) {
            return this.uri.getPort();
        }
        return this.isUseSecureConnection() ? 443 : 80;
    }

    public String getRequiredUser() {
        return this.resolveRequired(ConnectionProperties.USER);
    }

    public Optional<String> getUser() {
        return this.resolveOptional(ConnectionProperties.USER);
    }

    public boolean hasPassword() {
        return !Strings.isNullOrEmpty(this.resolveOptional(ConnectionProperties.PASSWORD).orElse(""));
    }

    public Optional<String> getSessionUser() {
        return this.resolveOptional(ConnectionProperties.SESSION_USER);
    }

    public Map<String, ClientSelectedRole> getRoles() {
        return this.resolveWithDefault(ConnectionProperties.ROLES, ImmutableMap.of());
    }

    public Optional<String> getApplicationNamePrefix() {
        return this.resolveOptional(ConnectionProperties.APPLICATION_NAME_PREFIX);
    }

    public Map<String, String> getExtraCredentials() {
        return this.resolveWithDefault(ConnectionProperties.EXTRA_CREDENTIALS, ImmutableMap.of());
    }

    public Optional<String> getClientInfo() {
        return this.resolveOptional(ConnectionProperties.CLIENT_INFO);
    }

    public Optional<Set<String>> getClientTags() {
        return this.resolveOptional(ConnectionProperties.CLIENT_TAGS);
    }

    public Optional<String> getTraceToken() {
        return this.resolveOptional(ConnectionProperties.TRACE_TOKEN);
    }

    public Map<String, String> getSessionProperties() {
        return this.resolveWithDefault(ConnectionProperties.SESSION_PROPERTIES, ImmutableMap.of());
    }

    public Optional<String> getSource() {
        return this.resolveOptional(ConnectionProperties.SOURCE);
    }

    public Optional<List<String>> getPath() {
        return this.resolveOptional(ConnectionProperties.SQL_PATH);
    }

    public Optional<HostAndPort> getSocksProxy() {
        return this.resolveOptional(ConnectionProperties.SOCKS_PROXY);
    }

    public Optional<HostAndPort> getHttpProxy() {
        return this.resolveOptional(ConnectionProperties.HTTP_PROXY);
    }

    public boolean isUseSecureConnection() {
        return this.resolveRequired(ConnectionProperties.SSL);
    }

    public Optional<String> getPassword() {
        return this.resolveOptional(ConnectionProperties.PASSWORD);
    }

    public ConnectionProperties.SslVerificationMode getSslVerification() {
        return this.resolveWithDefault(ConnectionProperties.SSL_VERIFICATION, ConnectionProperties.SslVerificationMode.FULL);
    }

    public Optional<String> getSslKeyStorePath() {
        return this.resolveOptional(ConnectionProperties.SSL_KEY_STORE_PATH);
    }

    public Optional<String> getSslKeyStorePassword() {
        return this.resolveOptional(ConnectionProperties.SSL_KEY_STORE_PASSWORD);
    }

    public Optional<String> getSslKeyStoreType() {
        return this.resolveOptional(ConnectionProperties.SSL_KEY_STORE_TYPE);
    }

    public boolean getSslUseSystemKeyStore() {
        return this.resolveWithDefault(ConnectionProperties.SSL_USE_SYSTEM_KEY_STORE, false);
    }

    public Optional<String> getSslTrustStorePath() {
        return this.resolveOptional(ConnectionProperties.SSL_TRUST_STORE_PATH);
    }

    public Optional<String> getSslTrustStorePassword() {
        return this.resolveOptional(ConnectionProperties.SSL_TRUST_STORE_PASSWORD);
    }

    public Optional<String> getSslTrustStoreType() {
        return this.resolveOptional(ConnectionProperties.SSL_TRUST_STORE_TYPE);
    }

    public boolean getSslUseSystemTrustStore() {
        return this.resolveWithDefault(ConnectionProperties.SSL_USE_SYSTEM_TRUST_STORE, false);
    }

    public Optional<String> getHostnameInCertificate() {
        return this.resolveOptional(ConnectionProperties.HOSTNAME_IN_CERTIFICATE);
    }

    public String getRequiredKerberosServicePrincipalPattern() {
        return this.resolveWithDefault(ConnectionProperties.KERBEROS_SERVICE_PRINCIPAL_PATTERN, "${SERVICE}@${HOST}");
    }

    public Optional<String> getKerberosRemoteServiceName() {
        return this.resolveOptional(ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME);
    }

    public String getRequiredKerberosRemoteServiceName() {
        return this.resolveRequired(ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME);
    }

    public boolean getRequiredKerberosUseCanonicalHostname() {
        return this.resolveWithDefault(ConnectionProperties.KERBEROS_USE_CANONICAL_HOSTNAME, false);
    }

    public Optional<String> getKerberosPrincipal() {
        return this.resolveOptional(ConnectionProperties.KERBEROS_PRINCIPAL);
    }

    public Optional<File> getKerberosConfigPath() {
        return this.resolveOptional(ConnectionProperties.KERBEROS_CONFIG_PATH);
    }

    public Optional<File> getKerberosKeytabPath() {
        return this.resolveOptional(ConnectionProperties.KERBEROS_KEYTAB_PATH);
    }

    public Optional<File> getKerberosCredentialCachePath() {
        return this.resolveOptional(ConnectionProperties.KERBEROS_CREDENTIAL_CACHE_PATH);
    }

    public boolean getKerberosDelegation() {
        return this.resolveWithDefault(ConnectionProperties.KERBEROS_DELEGATION, false);
    }

    public Optional<GSSCredential> getKerberosConstrainedDelegation() {
        return this.resolveOptional(ConnectionProperties.KERBEROS_CONSTRAINED_DELEGATION);
    }

    public Optional<String> getAccessToken() {
        return this.resolveOptional(ConnectionProperties.ACCESS_TOKEN);
    }

    public boolean isExternalAuthenticationEnabled() {
        return this.resolveWithDefault(ConnectionProperties.EXTERNAL_AUTHENTICATION, false);
    }

    public Optional<Duration> getExternalAuthenticationTimeout() {
        return this.resolveOptional(ConnectionProperties.EXTERNAL_AUTHENTICATION_TIMEOUT);
    }

    public Optional<List<ExternalRedirectStrategy>> getExternalRedirectStrategies() {
        return this.resolveOptional(ConnectionProperties.EXTERNAL_AUTHENTICATION_REDIRECT_HANDLERS);
    }

    public KnownTokenCache getExternalAuthenticationTokenCache() {
        return this.resolveWithDefault(ConnectionProperties.EXTERNAL_AUTHENTICATION_TOKEN_CACHE, KnownTokenCache.NONE);
    }

    public String getDnsResolverContext() {
        return this.resolveWithDefault(ConnectionProperties.DNS_RESOLVER_CONTEXT, null);
    }

    public Optional<Class<? extends DnsResolver>> getDnsResolver() {
        return this.resolveOptional(ConnectionProperties.DNS_RESOLVER);
    }

    public Optional<Boolean> getExplicitPrepare() {
        return this.resolveOptional(ConnectionProperties.EXPLICIT_PREPARE);
    }

    public Optional<Boolean> getAssumeNullCatalogMeansCurrentCatalog() {
        return this.resolveOptional(ConnectionProperties.ASSUME_NULL_CATALOG_MEANS_CURRENT_CATALOG);
    }

    public boolean isCompressionDisabled() {
        return this.resolveWithDefault(ConnectionProperties.DISABLE_COMPRESSION, false);
    }

    public Optional<String> getEncoding() {
        return this.resolveOptional(ConnectionProperties.ENCODING);
    }

    public boolean isAssumeLiteralNamesInMetadataCallsForNonConformingClients() {
        return this.resolveWithDefault(ConnectionProperties.ASSUME_LITERAL_NAMES_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS, false);
    }

    public boolean isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients() {
        return this.resolveWithDefault(ConnectionProperties.ASSUME_LITERAL_UNDERSCORE_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS, false);
    }

    public ZoneId getTimeZone() {
        return this.resolveWithDefault(ConnectionProperties.TIMEZONE, ZoneId.systemDefault());
    }

    public Locale getLocale() {
        return this.resolveWithDefault(ConnectionProperties.LOCALE, Locale.getDefault());
    }

    public Duration getTimeout() {
        return this.resolveWithDefault(ConnectionProperties.TIMEOUT, Duration.valueOf("30s"));
    }

    public LoggingLevel getHttpLoggingLevel() {
        return this.resolveWithDefault(ConnectionProperties.HTTP_LOGGING_LEVEL, LoggingLevel.NONE);
    }

    private Map<String, String> getResourceEstimates() {
        return this.resolveWithDefault(ConnectionProperties.RESOURCE_ESTIMATES, ImmutableMap.of());
    }

    @VisibleForTesting
    public Properties getProperties() {
        return this.properties;
    }

    private <V, T> T resolveRequired(ConnectionProperty<V, T> property) {
        return property.getRequiredValue(this.properties);
    }

    private <V, T> Optional<T> resolveOptional(ConnectionProperty<V, T> property) {
        return property.getValue(this.properties);
    }

    private <V, T> T resolveWithDefault(ConnectionProperty<V, T> property, T defaultValue) {
        return property.getValueOrDefault(this.properties, defaultValue);
    }

    public static boolean isSecureConnection(URI uri) {
        return uri.getScheme().equals("https") || uri.getScheme().equals("trino") && uri.getPort() == 443;
    }

    public ClientSession.Builder toClientSessionBuilder() {
        return ClientSession.builder().server(this.getHttpUri()).principal(this.getUser()).path(this.getPath().orElse(ImmutableList.of())).clientRequestTimeout(this.getTimeout()).user(this.getSessionUser()).clientTags(this.getClientTags().orElse(ImmutableSet.of())).source(this.getSource().orElse(null)).traceToken(this.getTraceToken()).clientInfo(this.getClientInfo().orElse(null)).catalog(this.getCatalog().orElse(null)).schema(this.getSchema().orElse(null)).timeZone(this.getTimeZone()).locale(this.getLocale()).properties(this.getSessionProperties()).credentials(this.getExtraCredentials()).transactionId(null).resourceEstimates(this.getResourceEstimates()).compressionDisabled(this.isCompressionDisabled()).encoding(this.getEncoding());
    }

    protected static Set<ConnectionProperty<?, ?>> allProperties() {
        return ConnectionProperties.allProperties();
    }

    private static Properties extractPropertiesFromUri(URI uri, List<PropertyName> restrictedProperties) {
        Properties result = new Properties();
        CatalogAndSchema catalogAndSchema = TrinoUri.parseCatalogAndSchema(uri);
        if (catalogAndSchema.getCatalog().isPresent() && restrictedProperties.contains((Object)ConnectionProperties.CATALOG.getPropertyName())) {
            throw new RestrictedPropertyException(PropertyName.CATALOG, "Catalog cannot be set in the URL");
        }
        if (catalogAndSchema.getSchema().isPresent() && restrictedProperties.contains((Object)ConnectionProperties.SCHEMA.getPropertyName())) {
            throw new RestrictedPropertyException(PropertyName.SCHEMA, "Schema cannot be set in the URL");
        }
        catalogAndSchema.getCatalog().ifPresent(value -> result.put(ConnectionProperties.CATALOG.getKey(), value));
        catalogAndSchema.getSchema().ifPresent(value -> result.put(ConnectionProperties.SCHEMA.getKey(), value));
        if (TrinoUri.isSecureConnection(uri)) {
            result.put(ConnectionProperties.SSL.getKey(), ConnectionProperties.SSL.encodeValue(true));
        }
        if (Strings.isNullOrEmpty(uri.getQuery())) {
            return result;
        }
        for (String arg : QUERY_SPLITTER.split(uri.getQuery())) {
            List<String> parts = ARG_SPLITTER.splitToList(arg);
            if (parts.size() != 2) {
                throw new RuntimeException(String.format("Connection argument is not a valid connection property: '%s'", parts.get(0)));
            }
            PropertyName name = PropertyName.findByKey(parts.get(0)).orElseThrow(() -> new RuntimeException(String.format("Unrecognized connection property '%s'", parts.get(0))));
            if (restrictedProperties.contains((Object)name)) {
                throw new RestrictedPropertyException(name, String.format("Connection property %s cannot be set in the URL", new Object[]{name}));
            }
            if (result.containsKey(parts.get(0)) && !TrinoUri.isUrlOverridableProperty(parts.get(0))) {
                throw new RuntimeException(String.format("Connection property %s is in the URL multiple times", parts.get(0)));
            }
            result.put(parts.get(0), parts.get(1));
        }
        return result;
    }

    private static boolean isUrlOverridableProperty(String name) {
        return name.equals(ConnectionProperties.SSL.getKey());
    }

    private static URI parseDriverUrl(String url) {
        TrinoUri.validatePrefix(url);
        URI uri = TrinoUri.parseUrl(url);
        if (Strings.isNullOrEmpty(uri.getHost())) {
            throw new RuntimeException("No host specified: " + url);
        }
        if (uri.getPort() == 0 || uri.getPort() > 65535) {
            throw new RuntimeException("Invalid port number: " + url);
        }
        return uri;
    }

    private static URI parseUrl(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid Trino URL: " + url, e);
        }
    }

    private static void validatePrefix(String url) {
        if (!url.startsWith(URL_START)) {
            throw new RuntimeException("Invalid Trino URL: " + url);
        }
        if (url.equals(URL_START)) {
            throw new RuntimeException("Empty Trino URL: " + url);
        }
    }

    private static CatalogAndSchema parseCatalogAndSchema(URI uri) {
        String path = uri.getPath();
        if (Strings.isNullOrEmpty(path) || path.equals("/")) {
            return new CatalogAndSchema(Optional.empty(), Optional.empty());
        }
        if (!path.startsWith("/")) {
            throw new RuntimeException("Path does not start with a slash: " + uri);
        }
        path = path.substring(1);
        List<String> parts = Splitter.on("/").splitToList(path);
        if (parts.get(parts.size() - 1).isEmpty()) {
            parts = parts.subList(0, parts.size() - 1);
        }
        if (parts.size() > 2) {
            throw new RuntimeException("Invalid path segments in URL: " + uri);
        }
        if (parts.get(0).isEmpty()) {
            throw new RuntimeException("Catalog name is empty: " + uri);
        }
        Optional<String> catalogName = Optional.of(parts.get(0));
        Optional<String> schemaName = Optional.empty();
        if (parts.size() > 1) {
            if (parts.get(1).isEmpty()) {
                throw new RuntimeException("Schema name is empty: " + uri);
            }
            schemaName = Optional.of(parts.get(1));
        }
        return new CatalogAndSchema(catalogName, schemaName);
    }

    private Properties mergeConnectionProperties(Properties urlProperties, Properties properties) {
        for (Object key : urlProperties.keySet()) {
            if (key == ConnectionProperties.SSL.getKey() || !properties.containsKey(key)) continue;
            throw new RuntimeException(String.format("Connection property %s is passed both by URL and properties", key));
        }
        Properties result = new Properties();
        result.putAll((Map<?, ?>)urlProperties);
        result.putAll((Map<?, ?>)properties);
        return result;
    }

    private void validateConnectionProperties(Properties connectionProperties) {
        ImmutableCollection errors;
        ImmutableList.Builder violations = ImmutableList.builder();
        for (String string : connectionProperties.stringPropertyNames()) {
            if (ConnectionProperties.forKey(string) != null) continue;
            violations.add(new IllegalArgumentException(String.format("Unrecognized connection property '%s'", string)));
        }
        for (ConnectionProperty connectionProperty : TrinoUri.allProperties()) {
            Optional<RuntimeException> validationError = connectionProperty.validate(connectionProperties);
            validationError.ifPresent(violations::add);
        }
        if (this.hasPassword() && !this.isUseSecureConnection()) {
            violations.add(new IllegalStateException("TLS/SSL is required for authentication with username and password"));
        }
        if ((errors = violations.build()).size() == 1) {
            throw (RuntimeException)errors.get(0);
        }
        if (!errors.isEmpty()) {
            String string = errors.stream().map(Throwable::getMessage).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining("\n"));
            throw new RuntimeException("Provided connection properties are invalid:\n" + string);
        }
    }

    @VisibleForTesting
    public static void setRedirectHandler(RedirectHandler handler) {
        REDIRECT_HANDLER.set(Objects.requireNonNull(handler, "handler is null"));
    }

    public static Optional<RedirectHandler> getRedirectHandler() {
        return Optional.ofNullable(REDIRECT_HANDLER.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TrinoUri trinoUri) {
        return new Builder().setUri(trinoUri.uri).setProperties(trinoUri.properties).setRestrictedProperties(trinoUri.restrictedProperties);
    }

    private static class CatalogAndSchema {
        private final Optional<String> catalog;
        private final Optional<String> schema;

        public CatalogAndSchema(Optional<String> catalog, Optional<String> schema) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.schema = Objects.requireNonNull(schema, "schema is null");
        }

        public Optional<String> getCatalog() {
            return this.catalog;
        }

        public Optional<String> getSchema() {
            return this.schema;
        }
    }

    public static final class Builder {
        private URI uri;
        private List<PropertyName> restrictedProperties = ImmutableList.of();
        private ImmutableMap.Builder<Object, Object> properties = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setUri(URI uri) {
            this.uri = Objects.requireNonNull(uri, "uri is null");
            return this;
        }

        public Builder setCatalog(String catalog) {
            return this.setProperty(ConnectionProperties.CATALOG, Objects.requireNonNull(catalog, "catalog is null"));
        }

        public Builder setSchema(String schema) {
            return this.setProperty(ConnectionProperties.SCHEMA, Objects.requireNonNull(schema, "schema is null"));
        }

        public Builder setRestrictedProperties(List<PropertyName> restrictedProperties) {
            this.restrictedProperties = Objects.requireNonNull(restrictedProperties, "restrictedProperties is null");
            return this;
        }

        public Builder setUser(String user) {
            return this.setProperty(ConnectionProperties.USER, Objects.requireNonNull(user, "user is null"));
        }

        public Builder setPassword(String password) {
            return this.setProperty(ConnectionProperties.PASSWORD, Objects.requireNonNull(password, "password is null"));
        }

        public Builder setSessionUser(String sessionUser) {
            return this.setProperty(ConnectionProperties.SESSION_USER, Objects.requireNonNull(sessionUser, "sessionUser is null"));
        }

        public Builder setRoles(Map<String, ClientSelectedRole> roles) {
            return this.setProperty(ConnectionProperties.ROLES, Objects.requireNonNull(roles, "roles is null"));
        }

        public Builder setSocksProxy(HostAndPort socksProxy) {
            return this.setProperty(ConnectionProperties.SOCKS_PROXY, Objects.requireNonNull(socksProxy, "socksProxy is null"));
        }

        public Builder setHttpProxy(HostAndPort httpProxy) {
            return this.setProperty(ConnectionProperties.HTTP_PROXY, Objects.requireNonNull(httpProxy, "httpProxy is null"));
        }

        public Builder setApplicationNamePrefix(String applicationNamePrefix) {
            return this.setProperty(ConnectionProperties.APPLICATION_NAME_PREFIX, Objects.requireNonNull(applicationNamePrefix, "applicationNamePrefix is null"));
        }

        public Builder setDisableCompression(Boolean disableCompression) {
            return this.setProperty(ConnectionProperties.DISABLE_COMPRESSION, Objects.requireNonNull(disableCompression, "disableCompression is null"));
        }

        public Builder setEncoding(String encoding) {
            return this.setProperty(ConnectionProperties.ENCODING, Objects.requireNonNull(encoding, "encoding is null"));
        }

        public Builder setAssumeLiteralNamesInMetadataCallsForNonConformingClients(boolean value) {
            return this.setProperty(ConnectionProperties.ASSUME_LITERAL_NAMES_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS, value);
        }

        public Builder setAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients(boolean value) {
            return this.setProperty(ConnectionProperties.ASSUME_LITERAL_UNDERSCORE_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS, value);
        }

        public Builder setSsl(Boolean ssl) {
            return this.setProperty(ConnectionProperties.SSL, Objects.requireNonNull(ssl, "ssl is null"));
        }

        public Builder setSslKeyStorePath(String sslKeyStorePath) {
            return this.setProperty(ConnectionProperties.SSL_KEY_STORE_PATH, Objects.requireNonNull(sslKeyStorePath, "sslKeyStorePath is null"));
        }

        public Builder setSslKeyStorePassword(String sslKeyStorePassword) {
            return this.setProperty(ConnectionProperties.SSL_KEY_STORE_PASSWORD, Objects.requireNonNull(sslKeyStorePassword, "sslKeyStorePassword is null"));
        }

        public Builder setSslKeyStoreType(String sslKeyStoreType) {
            return this.setProperty(ConnectionProperties.SSL_KEY_STORE_TYPE, Objects.requireNonNull(sslKeyStoreType, "sslKeyStoreType is null"));
        }

        public Builder setSslUseSystemKeyStore(boolean sslUseSystemKeyStore) {
            return this.setProperty(ConnectionProperties.SSL_USE_SYSTEM_KEY_STORE, sslUseSystemKeyStore);
        }

        public Builder setSslTrustStorePath(String sslTrustStorePath) {
            return this.setProperty(ConnectionProperties.SSL_TRUST_STORE_PATH, Objects.requireNonNull(sslTrustStorePath, "sslTrustStorePath is null"));
        }

        public Builder setSslTrustStorePassword(String sslTrustStorePassword) {
            return this.setProperty(ConnectionProperties.SSL_TRUST_STORE_PASSWORD, Objects.requireNonNull(sslTrustStorePassword, "sslTrustStorePassword is null"));
        }

        public Builder setSslTrustStoreType(String sslTrustStoreType) {
            return this.setProperty(ConnectionProperties.SSL_TRUST_STORE_TYPE, Objects.requireNonNull(sslTrustStoreType, "sslTrustStoreType is null"));
        }

        public Builder setSslUseSystemTrustStore(Boolean sslUseSystemTrustStore) {
            return this.setProperty(ConnectionProperties.SSL_USE_SYSTEM_TRUST_STORE, Objects.requireNonNull(sslUseSystemTrustStore, "sslUseSystemTrustStore is null"));
        }

        public Builder setKerberosServicePrincipalPattern(String kerberosServicePrincipalPattern) {
            return this.setProperty(ConnectionProperties.KERBEROS_SERVICE_PRINCIPAL_PATTERN, Objects.requireNonNull(kerberosServicePrincipalPattern, "kerberosServicePrincipalPattern is null"));
        }

        public Builder setKerberosUseCanonicalHostname(Boolean kerberosUseCanonicalHostname) {
            return this.setProperty(ConnectionProperties.KERBEROS_USE_CANONICAL_HOSTNAME, Objects.requireNonNull(kerberosUseCanonicalHostname, "kerberosUseCanonicalHostname is null"));
        }

        public Builder setKerberosPrincipal(String kerberosPrincipal) {
            return this.setProperty(ConnectionProperties.KERBEROS_PRINCIPAL, Objects.requireNonNull(kerberosPrincipal, "kerberosPrincipal is null"));
        }

        public Builder setKerberosConfigPath(String kerberosConfigPath) {
            return this.setKerberosConfigPath(new File(Objects.requireNonNull(kerberosConfigPath, "kerberosConfigPath is null")));
        }

        public Builder setKerberosConfigPath(File kerberosConfigPath) {
            return this.setProperty(ConnectionProperties.KERBEROS_CONFIG_PATH, Objects.requireNonNull(kerberosConfigPath, "kerberosConfigPath is null"));
        }

        public Builder setKerberosKeytabPath(String kerberosKeytabPath) {
            return this.setKerberosKeytabPath(new File(Objects.requireNonNull(kerberosKeytabPath, "kerberosKeytabPath is null")));
        }

        public Builder setKerberosKeytabPath(File kerberosKeytabPath) {
            return this.setProperty(ConnectionProperties.KERBEROS_KEYTAB_PATH, Objects.requireNonNull(kerberosKeytabPath, "kerberosKeytabPath is null"));
        }

        public Builder setKerberosCredentialCachePath(String kerberosCredentialCachePath) {
            return this.setKerberosCredentialCachePath(new File(Objects.requireNonNull(kerberosCredentialCachePath, "kerberosCredentialCachePath is null")));
        }

        public Builder setKerberosCredentialCachePath(File kerberosCredentialCachePath) {
            return this.setProperty(ConnectionProperties.KERBEROS_CREDENTIAL_CACHE_PATH, Objects.requireNonNull(kerberosCredentialCachePath, "kerberosCredentialCachePath is null"));
        }

        public Builder setKerberosDelegation(Boolean kerberosDelegation) {
            return this.setProperty(ConnectionProperties.KERBEROS_DELEGATION, Objects.requireNonNull(kerberosDelegation, "kerberosDelegation is null"));
        }

        public Builder setKerberosConstrainedDelegation(GSSCredential kerberosConstrainedDelegation) {
            return this.setProperty(ConnectionProperties.KERBEROS_CONSTRAINED_DELEGATION, Objects.requireNonNull(kerberosConstrainedDelegation, "kerberosConstrainedDelegation is null"));
        }

        public Builder setAccessToken(String accessToken) {
            return this.setProperty(ConnectionProperties.ACCESS_TOKEN, Objects.requireNonNull(accessToken, "accessToken is null"));
        }

        public Builder setExternalAuthentication(Boolean externalAuthentication) {
            return this.setProperty(ConnectionProperties.EXTERNAL_AUTHENTICATION, Objects.requireNonNull(externalAuthentication, "externalAuthentication is null"));
        }

        public Builder setExternalAuthenticationTimeout(Duration externalAuthenticationTimeout) {
            return this.setProperty(ConnectionProperties.EXTERNAL_AUTHENTICATION_TIMEOUT, Objects.requireNonNull(externalAuthenticationTimeout, "externalAuthenticationTimeout is null"));
        }

        public Builder setExternalAuthenticationRedirectHandlers(List<ExternalRedirectStrategy> externalRedirectStrategies) {
            return this.setProperty(ConnectionProperties.EXTERNAL_AUTHENTICATION_REDIRECT_HANDLERS, Objects.requireNonNull(externalRedirectStrategies, "externalRedirectStrategies is null"));
        }

        public Builder setExternalAuthenticationTokenCache(KnownTokenCache externalAuthenticationTokenCache) {
            return this.setProperty(ConnectionProperties.EXTERNAL_AUTHENTICATION_TOKEN_CACHE, Objects.requireNonNull(externalAuthenticationTokenCache, "externalAuthenticationTokenCache is null"));
        }

        public Builder setExtraCredentials(Map<String, String> extraCredentials) {
            return this.setProperty(ConnectionProperties.EXTRA_CREDENTIALS, Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
        }

        public Builder setHostnameInCertificate(String hostnameInCertificate) {
            return this.setProperty(ConnectionProperties.HOSTNAME_IN_CERTIFICATE, Objects.requireNonNull(hostnameInCertificate, "hostnameInCertificate is null"));
        }

        public Builder setTimeZone(ZoneId zoneId) {
            return this.setProperty(ConnectionProperties.TIMEZONE, Objects.requireNonNull(zoneId, "zoneId is null"));
        }

        public Builder setSslVerification(ConnectionProperties.SslVerificationMode sslVerification) {
            return this.setProperty(ConnectionProperties.SSL_VERIFICATION, Objects.requireNonNull(sslVerification, "sslVerification is null"));
        }

        public Builder setSslVerificationNone() {
            return this.setProperty(ConnectionProperties.SSL_VERIFICATION, ConnectionProperties.SslVerificationMode.NONE);
        }

        public Builder setLocale(Locale locale) {
            return this.setProperty(ConnectionProperties.LOCALE, Objects.requireNonNull(locale, "locale is null"));
        }

        public Builder setClientInfo(String clientInfo) {
            return this.setProperty(ConnectionProperties.CLIENT_INFO, Objects.requireNonNull(clientInfo, "clientInfo is null"));
        }

        public Builder setClientTags(Set<String> clientTags) {
            return this.setProperty(ConnectionProperties.CLIENT_TAGS, Objects.requireNonNull(clientTags, "clientTags is null"));
        }

        public Builder setTraceToken(String traceToken) {
            return this.setProperty(ConnectionProperties.TRACE_TOKEN, Objects.requireNonNull(traceToken, "traceToken is null"));
        }

        public Builder setSessionProperties(Map<String, String> sessionProperties) {
            return this.setProperty(ConnectionProperties.SESSION_PROPERTIES, Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
        }

        public Builder setSource(String source2) {
            return this.setProperty(ConnectionProperties.SOURCE, Objects.requireNonNull(source2, "source is null"));
        }

        public Builder setExplicitPrepare(boolean explicitPrepare) {
            return this.setProperty(ConnectionProperties.EXPLICIT_PREPARE, explicitPrepare);
        }

        public Builder setAssumeNullCatalogMeansCurrentCatalog(boolean assumeNullCatalogMeansCurrentCatalog) {
            return this.setProperty(ConnectionProperties.ASSUME_NULL_CATALOG_MEANS_CURRENT_CATALOG, assumeNullCatalogMeansCurrentCatalog);
        }

        public Builder setKerberosRemoteServiceName(String kerberosRemoteServiceName) {
            return this.setProperty(ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME, Objects.requireNonNull(kerberosRemoteServiceName, "kerberosRemoteServiceName is null"));
        }

        public Builder setDnsResolverContext(String dnsResolverContext) {
            return this.setProperty(ConnectionProperties.DNS_RESOLVER_CONTEXT, Objects.requireNonNull(dnsResolverContext, "dnsResolverContext is null"));
        }

        public Builder setDnsResolver(Class<? extends DnsResolver> dnsResolver) {
            return this.setProperty(ConnectionProperties.DNS_RESOLVER, Objects.requireNonNull(dnsResolver, "dnsResolver is null"));
        }

        public Builder setTimeout(Duration timeout2) {
            return this.setProperty(ConnectionProperties.TIMEOUT, Objects.requireNonNull(timeout2, "timeout is null"));
        }

        public Builder setHttpLoggingLevel(LoggingLevel level) {
            return this.setProperty(ConnectionProperties.HTTP_LOGGING_LEVEL, Objects.requireNonNull(level, "level is null"));
        }

        public Builder setResourceEstimates(Map<String, String> resourceEstimates) {
            return this.setProperty(ConnectionProperties.RESOURCE_ESTIMATES, Objects.requireNonNull(resourceEstimates, "resourceEstimates is null"));
        }

        public Builder setPath(List<String> path) {
            return this.setProperty(ConnectionProperties.SQL_PATH, Objects.requireNonNull(path, "path is null"));
        }

        <V, T> Builder setProperty(ConnectionProperty<V, T> connectionProperty, T value) {
            this.properties.put(connectionProperty.getKey(), connectionProperty.encodeValue(value));
            return this;
        }

        <T> Builder setProperties(Map<ConnectionProperty<?, T>, T> values2) {
            values2.forEach(this::setProperty);
            return this;
        }

        Builder setProperties(Properties properties) {
            this.properties.putAll(properties);
            return this;
        }

        public TrinoUri build() {
            return new TrinoUri(this.restrictedProperties, this.uri, this.toProperties(this.properties.buildOrThrow()));
        }

        private Properties toProperties(Map<Object, Object> values2) {
            Properties properties = new Properties();
            properties.putAll(values2);
            return properties;
        }
    }
}

