/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleMethods;
import io.airlift.bootstrap.LifeCycleMethodsMap;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class LifeCycleModule
implements Module {
    private final List<Object> injectedInstances = new ArrayList<Object>();
    private final LifeCycleMethodsMap lifeCycleMethodsMap = new LifeCycleMethodsMap();
    private final AtomicReference<LifeCycleManager> lifeCycleManager = new AtomicReference<Object>(null);

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bindListener(Matchers.any(), new ProvisionListener[]{this::provision});
    }

    private <T> void provision(ProvisionListener.ProvisionInvocation<T> provision) {
        Object obj = provision.provision();
        if (obj == null || !this.isLifeCycleClass(obj.getClass())) {
            return;
        }
        LifeCycleManager manager = this.lifeCycleManager.get();
        if (manager != null) {
            try {
                manager.addInstance(obj);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            this.injectedInstances.add(obj);
        }
    }

    @Provides
    @Singleton
    public LifeCycleManager getServerManager() throws Exception {
        LifeCycleManager lifeCycleManager = new LifeCycleManager(this.injectedInstances, this.lifeCycleMethodsMap);
        this.lifeCycleManager.set(lifeCycleManager);
        return lifeCycleManager;
    }

    private boolean isLifeCycleClass(Class<?> clazz) {
        LifeCycleMethods methods = this.lifeCycleMethodsMap.get(clazz);
        return methods.hasFor(PostConstruct.class) || methods.hasFor(PreDestroy.class);
    }
}

