/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.protocol;

import io.airlift.slice.Slice;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public sealed interface SpooledLocation {
    public Map<String, List<String>> headers();

    public static DirectLocation directLocation(URI uri, Map<String, List<String>> headers) {
        return new DirectLocation(uri, headers);
    }

    public static CoordinatorLocation coordinatorLocation(Slice identifier, Map<String, List<String>> headers) {
        return new CoordinatorLocation(identifier, headers);
    }

    public record DirectLocation(URI uri, Map<String, List<String>> headers) implements SpooledLocation
    {
        public DirectLocation {
            headers = Map.copyOf(Objects.requireNonNull(headers, "headers is null"));
        }
    }

    public record CoordinatorLocation(Slice identifier, Map<String, List<String>> headers) implements SpooledLocation
    {
        public CoordinatorLocation {
            headers = Map.copyOf(Objects.requireNonNull(headers, "headers is null"));
        }
    }
}

