/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.FaultFilter;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.Filter;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.RbacFilter;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.RouterFilter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class FilterRegistry {
    private static FilterRegistry instance;
    private final Map<String, Filter> supportedFilters = new HashMap<String, Filter>();

    private FilterRegistry() {
    }

    static synchronized FilterRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = FilterRegistry.newRegistry().register(FaultFilter.INSTANCE, RouterFilter.INSTANCE, RbacFilter.INSTANCE);
        }
        return instance;
    }

    @VisibleForTesting
    static FilterRegistry newRegistry() {
        return new FilterRegistry();
    }

    @VisibleForTesting
    FilterRegistry register(Filter ... filters) {
        for (Filter filter : filters) {
            for (String typeUrl : filter.typeUrls()) {
                this.supportedFilters.put(typeUrl, filter);
            }
        }
        return this;
    }

    @Nullable
    Filter get(String typeUrl) {
        return this.supportedFilters.get(typeUrl);
    }
}

