/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class ResumableOperationResult<@Nullable T> {
    private ResumableOperationResult() {
    }

    abstract @Nullable T getObject();

    abstract long getPersistedSize();

    static <T> ResumableOperationResult<T> complete(T t, long persistedSize) {
        return new CompletedResult(t, persistedSize);
    }

    static <T> ResumableOperationResult<T> incremental(long persistedSize) {
        return new IncrementalResult(persistedSize);
    }

    private static final class CompletedResult<T>
    extends ResumableOperationResult<T> {
        private final long persistedSize;
        private final T entity;

        private CompletedResult(T entity, long persistedSize) {
            this.entity = entity;
            this.persistedSize = persistedSize;
        }

        @Override
        public @Nullable T getObject() {
            return this.entity;
        }

        @Override
        public long getPersistedSize() {
            return this.persistedSize;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("persistedSize", this.persistedSize).add("entity", this.entity).toString();
        }
    }

    private static final class IncrementalResult<@Nullable T>
    extends ResumableOperationResult<T> {
        private final long persistedSize;

        private IncrementalResult(long persistedSize) {
            this.persistedSize = persistedSize;
        }

        @Override
        public @Nullable T getObject() {
            return null;
        }

        @Override
        public long getPersistedSize() {
            return this.persistedSize;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("persistedSize", this.persistedSize).toString();
        }
    }
}

